

<?php $__env->startPush('styles'); ?>
<style>
/* ===== BASE STYLES ===== */
:root {
    --primary: #3b82f6;
    --primary-dark: #2563eb;
    --danger: #ef4444;
    --warning: #f59e0b;
    --info: #3b82f6;
    --success: #10b981;
    --gray-50: #f9fafb;
    --gray-100: #f3f4f6;
    --gray-200: #e5e7eb;
    --gray-300: #d1d5db;
    --gray-400: #9ca3af;
    --gray-500: #6b7280;
    --gray-600: #4b5563;
    --gray-700: #374151;
    --gray-800: #1f2937;
    --gray-900: #111827;
}

/* ===== LAYOUT ===== */
.status-page {
    max-width: 1200px;
    margin: 0 auto;
    padding: 24px 20px;
}

/* ===== HEADER SECTION ===== */
.status-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 28px;
    flex-wrap: wrap;
    gap: 16px;
}

.header-title {
    display: flex;
    align-items: center;
    gap: 12px;
}

.header-title h1 {
    font-size: 1.8rem;
    font-weight: 700;
    color: var(--gray-900);
    margin: 0;
    line-height: 1.2;
}

.header-title .date-badge {
    background: var(--gray-100);
    color: var(--gray-700);
    padding: 6px 16px;
    border-radius: 30px;
    font-size: 0.9rem;
    font-weight: 500;
    border: 1px solid var(--gray-200);
}

.header-actions {
    display: flex;
    gap: 10px;
    flex-wrap: wrap;
}

.action-btn {
    width: 42px;
    height: 42px;
    border-radius: 12px;
    background: white;
    border: 1px solid var(--gray-200);
    color: var(--gray-600);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.2rem;
    cursor: pointer;
    transition: all 0.2s ease;
    box-shadow: 0 2px 4px rgba(0,0,0,0.02);
}

.action-btn:hover {
    background: var(--primary);
    border-color: var(--primary);
    color: white;
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(59,130,246,0.2);
}

/* ===== SUMMARY CARDS ===== */
.summary-cards {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 20px;
    margin-bottom: 32px;
}

.summary-card {
    background: white;
    border-radius: 16px;
    padding: 20px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.05);
    border: 1px solid var(--gray-200);
    display: flex;
    align-items: center;
    gap: 16px;
    transition: transform 0.2s, box-shadow 0.2s;
}

.summary-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 20px rgba(0,0,0,0.08);
}

.card-icon {
    width: 54px;
    height: 54px;
    border-radius: 14px;
    background: var(--gray-100);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.8rem;
    color: var(--primary);
}

.card-content h3 {
    font-size: 0.9rem;
    font-weight: 600;
    color: var(--gray-500);
    margin: 0 0 4px 0;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.card-content .card-number {
    font-size: 2rem;
    font-weight: 700;
    color: var(--gray-900);
    line-height: 1.2;
}

/* ===== USER LIST (DESKTOP TABLE) ===== */
.user-list-container {
    background: white;
    border-radius: 20px;
    border: 1px solid var(--gray-200);
    overflow: hidden;
    box-shadow: 0 4px 12px rgba(0,0,0,0.05);
}

.user-table {
    width: 100%;
    border-collapse: collapse;
}

.user-table th {
    text-align: left;
    padding: 18px 20px;
    background: var(--gray-50);
    font-weight: 600;
    font-size: 0.85rem;
    color: var(--gray-600);
    text-transform: uppercase;
    letter-spacing: 0.5px;
    border-bottom: 1px solid var(--gray-200);
}

.user-table td {
    padding: 16px 20px;
    border-bottom: 1px solid var(--gray-100);
    vertical-align: middle;
}

.user-table tr:last-child td {
    border-bottom: none;
}

.user-table tr:hover td {
    background: var(--gray-50);
}

.user-avatar {
    width: 44px;
    height: 44px;
    border-radius: 12px;
    background: linear-gradient(135deg, var(--primary), #60a5fa);
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 700;
    font-size: 1.2rem;
    text-transform: uppercase;
}

.user-info-cell {
    display: flex;
    align-items: center;
    gap: 14px;
}

.user-details {
    line-height: 1.4;
}

.user-name {
    font-weight: 600;
    color: var(--gray-900);
    font-size: 1rem;
}

.user-email {
    font-size: 0.85rem;
    color: var(--gray-500);
    margin-top: 2px;
}

.status-badge {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 6px 14px;
    border-radius: 30px;
    font-size: 0.85rem;
    font-weight: 600;
    white-space: nowrap;
}

.status-badge-danger {
    background: #fee2e2;
    color: #b91c1c;
}

.status-badge-warning {
    background: #ffedd5;
    color: #c2410c;
}

.status-badge-info {
    background: #dbeafe;
    color: #1e40af;
}

.status-badge i {
    font-size: 0.8rem;
}

.action-buttons {
    display: flex;
    gap: 8px;
    justify-content: flex-end;
}

.btn-icon {
    width: 36px;
    height: 36px;
    border-radius: 10px;
    background: var(--gray-100);
    border: none;
    color: var(--gray-700);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1rem;
    cursor: pointer;
    transition: all 0.2s;
}

.btn-icon:hover {
    background: var(--primary);
    color: white;
    transform: scale(1.05);
}

.btn-icon.approve {
    color: var(--success);
}
.btn-icon.approve:hover {
    background: var(--success);
    color: white;
}
.btn-icon.reject {
    color: var(--danger);
}
.btn-icon.reject:hover {
    background: var(--danger);
    color: white;
}

/* ===== EMPTY STATE ===== */
.empty-state {
    text-align: center;
    padding: 60px 20px;
    background: white;
    border-radius: 20px;
    border: 1px dashed var(--gray-300);
}

.empty-state i {
    font-size: 3rem;
    color: var(--success);
    margin-bottom: 16px;
}

.empty-state p {
    font-size: 1.2rem;
    font-weight: 600;
    color: var(--gray-700);
    margin-bottom: 8px;
}

.empty-state span {
    color: var(--gray-500);
    font-size: 0.95rem;
}

/* ===== MOBILE STYLES ===== */
@media (max-width: 768px) {
    .status-page {
        padding: 16px;
    }

    .header-title h1 {
        font-size: 1.5rem;
    }

    .header-title .date-badge {
        font-size: 0.8rem;
        padding: 4px 12px;
    }

    .summary-cards {
        grid-template-columns: 1fr;
        gap: 12px;
    }

    .user-table {
        display: none; /* Hide table on mobile */
    }

    /* Mobile card list */
    .mobile-user-list {
        display: flex;
        flex-direction: column;
        gap: 16px;
    }

    .mobile-user-card {
        background: white;
        border-radius: 16px;
        padding: 16px;
        border: 1px solid var(--gray-200);
        box-shadow: 0 2px 8px rgba(0,0,0,0.05);
        display: flex;
        flex-direction: column;
        gap: 12px;
    }

    .mobile-user-header {
        display: flex;
        align-items: center;
        gap: 14px;
    }

    .mobile-user-avatar {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        background: linear-gradient(135deg, var(--primary), #60a5fa);
        color: white;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 700;
        font-size: 1.4rem;
    }

    .mobile-user-info {
        flex: 1;
    }

    .mobile-user-name {
        font-weight: 700;
        color: var(--gray-900);
        font-size: 1.1rem;
        margin-bottom: 4px;
    }

    .mobile-user-email {
        font-size: 0.9rem;
        color: var(--gray-500);
    }

    .mobile-status {
        margin-top: 4px;
    }

    .mobile-actions {
        display: flex;
        gap: 12px;
        justify-content: flex-end;
        border-top: 1px solid var(--gray-100);
        padding-top: 12px;
        margin-top: 4px;
    }

    .mobile-actions .btn-icon {
        width: 44px;
        height: 44px;
        border-radius: 12px;
        font-size: 1.2rem;
    }
}

@media (min-width: 769px) {
    .mobile-user-list {
        display: none; /* Hide mobile list on desktop */
    }
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="status-page">
    <!-- Header Section -->
    <div class="status-header">
        <div class="header-title">
            <h1>
                <i class="fas fa-clipboard-list" style="color: var(--primary); margin-right: 10px;"></i>
                Status MOD
            </h1>
            <span class="date-badge"><?php echo e($date); ?></span>
        </div>
        <div class="header-actions">
            <button class="action-btn" title="Download Laporan" onclick="alert('Fitur download akan segera tersedia')">
                <i class="fas fa-download"></i>
            </button>
            <button class="action-btn" title="Filter" onclick="alert('Fitur filter akan segera tersedia')">
                <i class="fas fa-filter"></i>
            </button>
            <button class="action-btn" title="Pengaturan" onclick="alert('Fitur pengaturan akan segera tersedia')">
                <i class="fas fa-cog"></i>
            </button>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="summary-cards">
        <?php
            $belum = collect($users)->filter(fn($u) => $u['status_label'] == 'Belum Mengisi MOD')->count();
            $ttd = collect($users)->filter(fn($u) => $u['status_label'] == 'Menunggu Tanda Tangan')->count();
            $menunggu = collect($users)->filter(fn($u) => $u['status_label'] == 'Menunggu Persetujuan')->count();
        ?>
        <div class="summary-card">
            <div class="card-icon" style="background: #fee2e2; color: #b91c1c;">
                <i class="fas fa-clock"></i>
            </div>
            <div class="card-content">
                <h3>Belum Mengisi</h3>
                <div class="card-number"><?php echo e($belum); ?></div>
            </div>
        </div>
        <div class="summary-card">
            <div class="card-icon" style="background: #ffedd5; color: #c2410c;">
                <i class="fas fa-pencil-alt"></i>
            </div>
            <div class="card-content">
                <h3>Menunggu TTD</h3>
                <div class="card-number"><?php echo e($ttd); ?></div>
            </div>
        </div>
        <div class="summary-card">
            <div class="card-icon" style="background: #dbeafe; color: #1e40af;">
                <i class="fas fa-hourglass-half"></i>
            </div>
            <div class="card-content">
                <h3>Menunggu Persetujuan</h3>
                <div class="card-number"><?php echo e($menunggu); ?></div>
            </div>
        </div>
        <div class="summary-card">
            <div class="card-icon" style="background: #dcfce7; color: #166534;">
                <i class="fas fa-check-circle"></i>
            </div>
            <div class="card-content">
                <h3>Total User</h3>
                <div class="card-number"><?php echo e($total); ?></div>
            </div>
        </div>
    </div>

    <!-- Desktop Table -->
    <div class="user-list-container">
        <?php if($total > 0): ?>
            <table class="user-table">
                <thead>
                    <tr>
                        <th>User</th>
                        <th>Status</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $user = $item['user']; ?>
                        <tr>
                            <td>
                                <div class="user-info-cell">
                                    <div class="user-avatar">
                                        <?php echo e(strtoupper(substr($user->name, 0, 1))); ?>

                                    </div>
                                    <div class="user-details">
                                        <div class="user-name"><?php echo e($user->name); ?></div>
                                        <div class="user-email"><?php echo e($user->email); ?></div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="status-badge status-badge-<?php echo e($item['badge_class']); ?>">
                                    <i class="fas fa-<?php echo e($item['icon']); ?>"></i>
                                    <?php echo e($item['status_label']); ?>

                                </span>
                            </td>
                            <td>
                                <div class="action-buttons">
                                    <?php if($item['status_label'] == 'Menunggu Persetujuan'): ?>
                                        <button class="btn-icon approve" title="Setujui MOD" onclick="alert('Fitur persetujuan akan segera tersedia')">
                                            <i class="fas fa-check"></i>
                                        </button>
                                        <button class="btn-icon reject" title="Tolak MOD" onclick="alert('Fitur penolakan akan segera tersedia')">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    <?php else: ?>
                                        <button class="btn-icon" title="Lihat Detail" onclick="alert('Fitur detail akan segera tersedia')">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                    <?php endif; ?>
                                    <button class="btn-icon" title="Hapus" onclick="if(confirm('Yakin ingin menghapus user ini dari daftar?')) this.closest('tr').remove()">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        <?php else: ?>
            <div class="empty-state">
                <i class="fas fa-check-circle"></i>
                <p>Semua user sudah mengisi MOD hari ini</p>
                <span>Tidak ada user yang perlu ditindaklanjuti</span>
            </div>
        <?php endif; ?>
    </div>

    <!-- Mobile Card List (tetap ada, namun disembunyikan di desktop) -->
    <div class="mobile-user-list">
        <?php if($total > 0): ?>
            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $user = $item['user']; ?>
                <div class="mobile-user-card">
                    <div class="mobile-user-header">
                        <div class="mobile-user-avatar">
                            <?php echo e(strtoupper(substr($user->name, 0, 1))); ?>

                        </div>
                        <div class="mobile-user-info">
                            <div class="mobile-user-name"><?php echo e($user->name); ?></div>
                            <div class="mobile-user-email"><?php echo e($user->email); ?></div>
                            <div class="mobile-status">
                                <span class="status-badge status-badge-<?php echo e($item['badge_class']); ?>">
                                    <i class="fas fa-<?php echo e($item['icon']); ?>"></i>
                                    <?php echo e($item['status_label']); ?>

                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="mobile-actions">
                        <?php if($item['status_label'] == 'Menunggu Persetujuan'): ?>
                            <button class="btn-icon approve" title="Setujui" onclick="alert('Fitur persetujuan akan segera tersedia')">
                                <i class="fas fa-check"></i>
                            </button>
                            <button class="btn-icon reject" title="Tolak" onclick="alert('Fitur penolakan akan segera tersedia')">
                                <i class="fas fa-times"></i>
                            </button>
                        <?php else: ?>
                            <button class="btn-icon" title="Detail" onclick="alert('Fitur detail akan segera tersedia')">
                                <i class="fas fa-eye"></i>
                            </button>
                        <?php endif; ?>
                        <button class="btn-icon" title="Hapus" onclick="if(confirm('Yakin ingin menghapus user ini?')) this.closest('.mobile-user-card').remove()">
                            <i class="fas fa-trash"></i>
                        </button>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <div class="empty-state">
                <i class="fas fa-check-circle"></i>
                <p>Semua user sudah mengisi MOD hari ini</p>
                <span>Tidak ada user yang perlu ditindaklanjuti</span>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('mobile-content'); ?>
<div class="status-page-mobile">
    <!-- Header mobile -->
    <div class="mobile-page-header">
        <h2><i class="fas fa-clipboard-list" style="margin-right: 8px;"></i> Status MOD</h2>
        <span class="date-badge"><?php echo e($date); ?></span>
    </div>

    <!-- Summary Cards untuk mobile (grid 2 kolom) -->
    <div class="mobile-summary-cards">
        <?php
            $belum = collect($users)->filter(fn($u) => $u['status_label'] == 'Belum Mengisi MOD')->count();
            $ttd = collect($users)->filter(fn($u) => $u['status_label'] == 'Menunggu Tanda Tangan')->count();
            $menunggu = collect($users)->filter(fn($u) => $u['status_label'] == 'Menunggu Persetujuan')->count();
        ?>
        <div class="summary-card">
            <div class="card-icon" style="background: #fee2e2; color: #b91c1c;">
                <i class="fas fa-clock"></i>
            </div>
            <div class="card-content">
                <h3>Belum Isi</h3>
                <div class="card-number"><?php echo e($belum); ?></div>
            </div>
        </div>
        <div class="summary-card">
            <div class="card-icon" style="background: #ffedd5; color: #c2410c;">
                <i class="fas fa-pencil-alt"></i>
            </div>
            <div class="card-content">
                <h3>TTD</h3>
                <div class="card-number"><?php echo e($ttd); ?></div>
            </div>
        </div>
        <div class="summary-card">
            <div class="card-icon" style="background: #dbeafe; color: #1e40af;">
                <i class="fas fa-hourglass-half"></i>
            </div>
            <div class="card-content">
                <h3>Persetujuan</h3>
                <div class="card-number"><?php echo e($menunggu); ?></div>
            </div>
        </div>
        <div class="summary-card">
            <div class="card-icon" style="background: #dcfce7; color: #166534;">
                <i class="fas fa-check-circle"></i>
            </div>
            <div class="card-content">
                <h3>Total</h3>
                <div class="card-number"><?php echo e($total); ?></div>
            </div>
        </div>
    </div>

    <!-- Daftar User Mobile (menggunakan komponen yang sama) -->
    <div class="mobile-user-list">
        <?php if($total > 0): ?>
            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $user = $item['user']; ?>
                <div class="mobile-user-card">
                    <div class="mobile-user-header">
                        <div class="mobile-user-avatar">
                            <?php echo e(strtoupper(substr($user->name, 0, 1))); ?>

                        </div>
                        <div class="mobile-user-info">
                            <div class="mobile-user-name"><?php echo e($user->name); ?></div>
                            <div class="mobile-user-email"><?php echo e($user->email); ?></div>
                            <div class="mobile-status">
                                <span class="status-badge status-badge-<?php echo e($item['badge_class']); ?>">
                                    <i class="fas fa-<?php echo e($item['icon']); ?>"></i>
                                    <?php echo e($item['status_label']); ?>

                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="mobile-actions">
                        <?php if($item['status_label'] == 'Menunggu Persetujuan'): ?>
                            <button class="btn-icon approve" title="Setujui" onclick="alert('Fitur persetujuan akan segera tersedia')">
                                <i class="fas fa-check"></i>
                            </button>
                            <button class="btn-icon reject" title="Tolak" onclick="alert('Fitur penolakan akan segera tersedia')">
                                <i class="fas fa-times"></i>
                            </button>
                        <?php else: ?>
                            <button class="btn-icon" title="Detail" onclick="alert('Fitur detail akan segera tersedia')">
                                <i class="fas fa-eye"></i>
                            </button>
                        <?php endif; ?>
                        <button class="btn-icon" title="Hapus" onclick="if(confirm('Yakin ingin menghapus user ini?')) this.closest('.mobile-user-card').remove()">
                            <i class="fas fa-trash"></i>
                        </button>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <div class="empty-state">
                <i class="fas fa-check-circle"></i>
                <p>Semua user sudah mengisi MOD hari ini</p>
                <span>Tidak ada user yang perlu ditindaklanjuti</span>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
/* Gaya tambahan khusus untuk tampilan mobile di dalam mobile-content */
.mobile-page-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 20px;
    flex-wrap: wrap;
    gap: 10px;
}

.mobile-page-header h2 {
    font-size: 1.4rem;
    font-weight: 700;
    color: var(--gray-900);
    margin: 0;
    display: flex;
    align-items: center;
}

.mobile-page-header .date-badge {
    background: var(--gray-100);
    color: var(--gray-700);
    padding: 4px 12px;
    border-radius: 30px;
    font-size: 0.8rem;
    font-weight: 500;
    border: 1px solid var(--gray-200);
}

.mobile-summary-cards {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 12px;
    margin-bottom: 24px;
}

.mobile-summary-cards .summary-card {
    padding: 16px;
    gap: 12px;
}

.mobile-summary-cards .card-icon {
    width: 44px;
    height: 44px;
    font-size: 1.4rem;
}

.mobile-summary-cards .card-number {
    font-size: 1.5rem;
}

/* Menyesuaikan jarak karena mobile-content sudah punya padding dari layout */
.status-page-mobile {
    padding: 0;
}

/* Memastikan card user tidak terlalu lebar */
.mobile-user-card {
    margin-bottom: 12px;
}

/* Responsive untuk layar sangat kecil */
@media (max-width: 360px) {
    .mobile-summary-cards {
        grid-template-columns: 1fr;
    }
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Optional: Add any dynamic behavior here
    // For example, confirm deletion
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.AdminLayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\#PKL PROJECT\pklproject\resources\views/admin/usermod.blade.php ENDPATH**/ ?>