<?php $__env->startPush('styles'); ?>
<style>
    /* ✅ CSS KHUSUS DASHBOARD — dipindahkan dari layout */
    .dashboard-title {
        font-size: 1.5rem;
        font-weight: 700;
        margin-bottom: 20px;
        color: #0f172a;
    }

    .desktop-cards {
        display: flex;
        flex-direction: column;
        gap: 20px;
    }

    .desktop-card {
        background: white;
        border-radius: 16px;
        padding: 20px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.04);
        display: flex;
        justify-content: space-between;
        align-items: center;
        transition: transform 0.25s, box-shadow 0.25s;
        text-decoration: none;
    }

    .desktop-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 6px 18px rgba(0,0,0,0.08);
    }

    .card-content {
        display: flex;
        align-items: center;
    }

    .card-icon {
        width: 50px;
        height: 50px;
        border-radius: 14px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 20px;
        font-size: 1.4rem;
    }

    .card-accent {
        background: rgba(59, 130, 246, 0.12);
        color: #3b82f6;
    }

    .card-text h3 {
        font-weight: 600;
        margin-bottom: 6px;
        font-size: 1.1rem;
        color: #1e293b;
    }

    .card-text p {
        font-size: 0.9rem;
        color: #64748b;
        line-height: 1.5;
    }

    .card-arrow {
        color: #cbd5e1;
        font-size: 1.2rem;
    }

    /* Badge notifikasi */
    .badge {
        position: absolute;
        top: -6px;
        right: -6px;
        background: #ef4444;
        color: white;
        font-size: 0.7rem;
        font-weight: bold;
        padding: 2px 6px;
        border-radius: 10px;
        min-width: 18px;
        text-align: center;
    }

    /* ===== MOBILE DASHBOARD ===== */
    @media (max-width: 1023px) {
        .mobile-cards {
            display: flex;
            flex-direction: column;
            gap: 16px;
        }

        .mobile-card {
            background: white;
            border-radius: 16px;
            padding: 18px;
            box-shadow: 0 4px 10px rgba(0,0,0,0.05);
            display: flex;
            justify-content: space-between;
            align-items: center;
            transition: transform 0.2s;
            text-decoration: none;
            width: 100%;
        }

        .mobile-card:hover {
            transform: translateY(-2px);
        }

        .mobile-card-content {
            display: flex;
            align-items: center;
        }

        .mobile-card-icon {
            width: 44px;
            height: 44px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 16px;
            font-size: 1.3rem;
        }

        .mobile-card-accent {
            background: rgba(59, 130, 246, 0.12);
            color: #3b82f6;
        }

        .mobile-card-text h3 {
            font-weight: 600;
            margin-bottom: 4px;
            font-size: 1rem;
            color: #1e293b;
        }

        .mobile-card-text p {
            font-size: 0.85rem;
            color: #64748b;
            line-height: 1.4;
        }

        .mobile-card-arrow {
            color: #cbd5e1;
            font-size: 1.1rem;
        }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <h1 class="dashboard-title">Manajemen</h1>

    <div class="desktop-cards">
        <a href="<?php echo e(route('admin.manajemen.usermanajemen')); ?>" class="desktop-card">
            <div class="card-content">
                <div class="card-icon card-accent">
                    <i class="fas fa-users"></i>
                </div>
                <div class="card-text">
                    <h3>Manajemen User</h3>
                    <p>Hapus user</p>
                </div>
            </div>
            <i class="fas fa-chevron-right card-arrow"></i>
        </a>

        <a href="<?php echo e(route('admin.manajemen.checklist')); ?>" class="desktop-card">
            <div class="card-content">
                <div class="card-icon card-accent">
                    <i class="fas fa-list"></i>
                </div>
                <div class="card-text">
                   <h3>Manajemen Checklist MOD</h3>
                    <p>Ubah pertanyaan dan kategori checklist</p>
                </div>
            </div>
            <i class="fas fa-chevron-right card-arrow"></i>
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('mobile-content'); ?>
<h1 class="dashboard-title">Manajemen</h1>

    <div class="mobile-cards">
        <a href="<?php echo e(route('admin.manajemen.usermanajemen')); ?>" class="mobile-card">
            <div class="mobile-card-content">
                <div class="mobile-card-icon mobile-card-accent">
                    <i class="fas fa-users"></i>
                </div>
                <div class="mobile-card-text">
                    <h3>Manajemen User</h3>
                    <p>Hapus user</p>
                </div>
            </div>
            <i class="fas fa-chevron-right mobile-card-arrow"></i>
        </a>

        <a href="<?php echo e(route('admin.manajemen.checklist')); ?>" class="mobile-card">
            <div class="mobile-card-content">
                <div class="mobile-card-icon mobile-card-accent">
                    <i class="fas fa-list"></i>
                </div>
                <div class="mobile-card-text">
                    <h3>Manajemen Checklist MOD</h3>
                    <p>Ubah pertanyaan dan kategori checklist</p>
                </div>
            </div>
            <i class="fas fa-chevron-right card-arrow"></i>
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.AdminLayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\#PKL PROJECT\pklproject\resources\views/admin/manajemen.blade.php ENDPATH**/ ?>