@extends('layouts.UserLayout')

@push('styles')
    <style>
        /* ===== MODAL STYLES (tambahan) ===== */
        .exit-confirmation-modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.5);
            z-index: 10000;
            align-items: center;
            justify-content: center;
        }
        .modal-content {
            background: white;
            border-radius: 16px;
            padding: 32px;
            max-width: 400px;
            width: 90%;
            box-shadow: 0 10px 25px rgba(0,0,0,0.2);
        }
        .modal-title {
            font-size: 1.5rem;
            font-weight: 700;
            color: #1f2937;
            margin-bottom: 16px;
        }
        .modal-message {
            color: #6b7280;
            font-size: 1rem;
            line-height: 1.6;
            margin-bottom: 24px;
        }
        .modal-buttons {
            display: flex;
            gap: 12px;
            justify-content: center;
        }
        .modal-btn {
            padding: 12px 24px;
            border-radius: 10px;
            font-weight: 600;
            cursor: pointer;
            border: none;
            font-size: 1rem;
            flex: 1;
        }
        .modal-btn-confirm {
            background: #3b82f6;
            color: white;
        }
        .modal-btn-confirm:hover {
            background: #2563eb;
        }
        /* ===== AKHIR MODAL ===== */

        /* style lainnya tetap sama persis seperti yang Anda berikan */
        .dashboard-title {
            font-size: 1.6rem;
            font-weight: 800;
            margin-bottom: 24px;
            color: #0f172a;
            background: linear-gradient(135deg, #0f2a4d, #3b82f6);
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
            position: relative;
        }
        .dashboard-title::after {
            content: '';
            display: block;
            width: 60px;
            height: 4px;
            background: linear-gradient(to right, #3b82f6, #5d8fd9);
            border-radius: 2px;
            margin-top: 8px;
        }
        .scrollable-content {
            height: calc(100vh - 120px);
            overflow-y: auto;
            padding-right: 8px;
            scroll-behavior: smooth;
        }
        .checklist-list {
            display: flex;
            flex-direction: column;
            gap: 18px;
        }
        .checklist-item {
            background: white;
            border-radius: 16px;
            padding: 18px 20px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.04);
            display: flex;
            align-items: center;
            border: 1px solid #e2e8f0;
            transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
            position: relative;
            overflow: hidden;
        }
        .checklist-item::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 4px;
            height: 100%;
            background: linear-gradient(to bottom, #3b82f6, #5d8fd9);
            opacity: 0;
            transition: opacity 0.3s ease;
        }
        .checklist-item:hover:not(.disabled) {
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(59, 130, 246, 0.15);
            border-color: #cbd5e1;
        }
        .checklist-item:hover:not(.disabled)::before {
            opacity: 1;
        }
        .hotel-logo {
            width: 60px;
            height: 60px;
            object-fit: contain;
            margin-right: 14px;
            border-radius: 10px;
            background: #f8fafc;
            padding: 6px;
            transition: transform 0.3s ease;
        }
        .checklist-item:hover .hotel-logo {
            transform: scale(1.05);
        }
        .checklist-title {
            font-weight: 600;
            font-size: 1.12rem;
            color: #0f172a;
            flex-grow: 1;
            line-height: 1.3;
        }
        .room-progress {
            background: #dbeafe;
            color: #1e40af;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 0.85rem;
            font-weight: 600;
            margin-left: 8px;
        }
        .signature-section {
            background: white;
            border-radius: 16px;
            padding: 24px;
            margin-top: 28px;
            border: 1px solid #e2e8f0;
            box-shadow: 0 4px 14px rgba(0, 0, 0, 0.05);
            transition: box-shadow 0.3s ease;
        }
        .signature-section:hover {
            box-shadow: 0 6px 20px rgba(59, 130, 246, 0.12);
        }
        .signature-header {
            font-size: 1.15rem;
            font-weight: 700;
            color: #0f2a4d;
            text-align: center;
            margin-bottom: 16px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }
        .signature-header i {
            color: #3b82f6;
        }
        .signature-area {
            background: #f8fafc;
            border: 2px dashed #cbd5e1;
            border-radius: 12px;
            height: 130px;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            transition: border-color 0.3s ease, background 0.3s ease;
        }
        .signature-area canvas {
            touch-action: none;
            cursor: crosshair;
            display: block;
            width: 100%;
            height: 100%;
        }
        .signature-area.is-drawing {
            border-color: #3b82f6;
            background: #eff6ff;
        }
        .signature-actions {
            display: flex;
            justify-content: center;
            margin-top: 20px;
            gap: 16px;
        }
        .signature-disabled {
            opacity: 0.45;
            filter: grayscale(0.4);
            pointer-events: none;
        }
        .signature-area.disabled {
            opacity: 0.45;
            filter: grayscale(1);
            pointer-events: none;
        }
        .signature-area.disabled::after {
            position: absolute;
            inset: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            font-size: 0.95rem;
            color: #334155;
            background: rgba(248, 250, 252, 0.8);
            text-align: center;
            padding: 12px;
        }
        .btn-signature {
            padding: 10px 20px;
            border-radius: 50px;
            font-size: 0.9rem;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 8px;
            cursor: pointer;
            transition: all 0.25s cubic-bezier(0.34, 1.56, 0.64, 1);
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.08);
        }
        .btn-hapus {
            background: #f8fafc;
            border: 1px solid #e2e8f0;
            color: #64748b;
        }
        .btn-hapus:hover {
            background: #e2e8f0;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        .btn-simpan {
            background: linear-gradient(135deg, #3b82f6, #2563eb);
            border: none;
            color: white;
            box-shadow: 0 4px 10px rgba(59, 130, 246, 0.3);
        }
        .btn-simpan:hover {
            background: linear-gradient(135deg, #2563eb, #1d4ed8);
            transform: translateY(-2px);
            box-shadow: 0 6px 14px rgba(59, 130, 246, 0.4);
        }
        .btn-submit {
            width: 100%;
            padding: 14px 20px;
            background: #f1f5f9;
            border: none;
            border-radius: 12px;
            font-size: 1.05rem;
            font-weight: 700;
            color: #64748b;
            margin-top: 28px;
            cursor: not-allowed;
            transition: all 0.3s ease;
            letter-spacing: 0.5px;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.08);
        }
        .btn-submit.active {
            background: linear-gradient(135deg, #0f2a4d, #1a3e6d);
            color: white;
            cursor: pointer;
            box-shadow: 0 6px 16px rgba(15, 42, 77, 0.3);
        }
        .btn-submit.active:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(15, 42, 77, 0.4);
        }
        @media (max-width: 1023px) {
            .scrollable-content {
                height: auto;
                overflow-y: visible;
                padding-right: 0;
            }
            .dashboard-title {
                font-size: 1.4rem;
                padding-top: 25px;
                text-align: center;
            }
            .dashboard-title::after {
                margin: 12px auto 0;
            }
            .checklist-item {
                padding: 16px;
                border-radius: 14px;
                align-items: flex-start;
            }
            .hotel-logo {
                width: 60px;
                height: 60px;
                margin-right: 12px;
            }
            .checklist-title {
                font-size: 0.98rem;
                white-space: normal;
                overflow: hidden;
                text-overflow: ellipsis;
                display: -webkit-box;
                -webkit-line-clamp: 2;
                -webkit-box-orient: vertical;
            }
            .room-progress {
                font-size: 0.8rem;
                padding: 3px 10px;
            }
            .signature-section {
                padding: 20px;
                margin-top: 24px;
                margin-bottom: 20px;
            }
            .signature-header {
                font-size: 1.05rem;
            }
            .signature-area {
                height: 110px;
                border-radius: 10px;
            }
            .btn-signature {
                padding: 8px 16px;
                font-size: 0.85rem;
            }
            .btn-submit {
                padding: 12px 16px;
                font-size: 1rem;
                margin-top: 24px;
                margin-bottom: 20px;
            }
        }
        @media (min-width: 1024px) {
            .scrollable-content::-webkit-scrollbar {
                width: 6px;
            }
            .scrollable-content::-webkit-scrollbar-track {
                background: #f1f5f9;
                border-radius: 3px;
            }
            .scrollable-content::-webkit-scrollbar-thumb {
                background: #cbd5e1;
                border-radius: 3px;
            }
            .scrollable-content::-webkit-scrollbar-thumb:hover {
                background: #94a3b8;
            }
        }
        .empty-state {
            text-align: center;
            padding: 40px 20px;
            color: #64748b;
        }
        .empty-state i {
            font-size: 2.5rem;
            margin-bottom: 16px;
            color: #10b981;
        }
        .disabled {
            opacity: 0.6;
            cursor: not-allowed;
        }
        .disabled .hotel-logo {
            filter: grayscale(1);
        }
        .success-message {
            background: #d1fae5;
            color: #065f46;
            padding: 16px;
            border-radius: 10px;
            margin-bottom: 20px;
            border-left: 4px solid #10b981;
            font-size: 0.95rem;
        }
        .alert-message {
            background: #fee2e2;
            color: #991b1b;
            padding: 16px;
            border-radius: 10px;
            margin-bottom: 20px;
            border-left: 4px solid #ef4444;
            font-size: 0.95rem;
        }
    </style>
@endpush

@section('content')
{{-- Modal Sukses Simpan Tanda Tangan --}}
<div id="successModal" class="exit-confirmation-modal" style="display: none;">
    <div class="modal-content" style="text-align: center;">
        <div style="font-size: 4rem; color: #10b981; margin-bottom: 16px;">✓</div>
        <h3 class="modal-title" style="color: #065f46;">Berhasil</h3>
        <p class="modal-message" id="successMessage">Tanda tangan berhasil disimpan!</p>
        <button id="closeSuccessModal" class="modal-btn modal-btn-confirm" style="background: #3b82f6; color: white; border: none; padding: 12px 24px; border-radius: 10px; font-weight: 600; cursor: pointer; min-width: 120px;">OK</button>
    </div>
</div>

<h1 class="dashboard-title">Checklist MOD</h1>

@if(session('success'))
    <div class="success-message">{{ session('success') }}</div>
@endif
@if(session('error'))
    <div class="alert-message">{{ session('error') }}</div>
@endif

@if(!$isEventDay)
    <div class="empty-state">
        <i class="fas fa-calendar-times"></i>
        <p>MOD tidak tersedia hari ini.</p>
    </div>
@elseif($submitted)
    {{-- Mode readonly setelah submit --}}
    <div class="empty-state" style="margin-bottom: 20px;">
        <i class="fas fa-check-circle" style="color: #3b82f6;"></i>
        <p style="font-weight: 600;">Anda telah mengirimkan MOD hari ini</p>
        <span style="color: #6b7280;">Menunggu persetujuan admin</span>
    </div>

    <div class="checklist-list" style="opacity: 0.6; pointer-events: none;">
        @foreach($accessibleChecklists as $item)
            @php
                $checklist = $item['checklist'];
                $completed = $item['completed'];
                $modSession = \App\Models\ModSession::where('user_id', auth()->id())
                    ->where('event_date', now()->toDateString())
                    ->where('hotel', $checklist->hotel)
                    ->first();
                $currentRoomCount = $modSession ? $modSession->room_inspection_count : 0;
            @endphp
            <div class="checklist-item disabled" style="background: #f9fafb;">
                <img src="{{ $checklist->hotel === 'HARRIS' ? asset('assets/harris.png') : asset('assets/pop.png') }}"
                     class="hotel-logo" style="filter: grayscale(1);" alt="">
                <div class="checklist-title" style="color: #94a3b8;">
                    {{ $checklist->hotel }} - {{ $checklist->title }}
                    @if($checklist->mod_type === 'room_inspection')
                        <span class="room-progress" style="background: #e2e8f0; color: #64748b;">{{ $currentRoomCount }}/5 Rooms</span>
                    @endif
                </div>
                @if($completed)
                    <span style="margin-left:auto; color:#16a34a;">✓ Selesai</span>
                @endif
            </div>
        @endforeach
    </div>

    {{-- Signature Section disabled --}}
    <div class="signature-section" style="opacity: 0.6; pointer-events: none;">
        <div class="signature-header">
            <i class="fas fa-signature"></i>
            Tanda Tangan Digital
        </div>
        <div class="signature-area disabled" style="border-color: #cbd5e1;">
            <canvas id="signature-pad" style="display: none;"></canvas>
            <div style="text-align: center; color: #64748b; padding: 20px;">
                <i class="fas fa-check-circle" style="color: #10b981; font-size: 2rem;"></i>
                <p style="margin-top: 8px;">Anda sudah mengirimkan tanda tangan</p>
            </div>
        </div>
    </div>

@else
    {{-- Mode aktif (seperti biasa) --}}
    <div class="scrollable-content">
        <div class="checklist-list">
            @foreach($accessibleChecklists as $item)
                @php
                    $checklist = $item['checklist'];
                    $canAccess = $item['can_access'];
                    $completed = $item['completed'];
                    $roomCount = $item['room_count'] ?? 0;
                    
                    $modSession = \App\Models\ModSession::where('user_id', auth()->id())
                        ->where('event_date', now()->toDateString())
                        ->where('hotel', $checklist->hotel)
                        ->first();
                    
                    $currentRoomCount = $modSession ? $modSession->room_inspection_count : 0;
                    
                    if ($completed) {
                        $state = 'done';
                    } elseif ($canAccess) {
                        $state = 'active';
                    } else {
                        $state = 'locked';
                    }
                @endphp

                @if($state === 'active')
                    <a href="{{ route('user.checklist.fill', ['checklistId' => $checklist->id, 'step' => 0]) }}"
                       class="checklist-item" style="text-decoration:none; color:inherit;">
                        <img src="{{ $checklist->hotel === 'HARRIS' ? asset('assets/harris.png') : asset('assets/pop.png') }}"
                             class="hotel-logo" alt="">
                        <div class="checklist-title">
                            {{ $checklist->hotel }} - {{ $checklist->title }}
                            @if($checklist->mod_type === 'room_inspection')
                                <span class="room-progress">{{ $currentRoomCount }}/5 Rooms</span>
                            @endif
                        </div>
                    </a>
                @elseif($state === 'done')
                    <div class="checklist-item disabled" style="opacity:.55">
                        <img src="{{ $checklist->hotel === 'HARRIS' ? asset('assets/harris.png') : asset('assets/pop.png') }}"
                             class="hotel-logo" alt="">
                        <div class="checklist-title">
                            {{ $checklist->hotel }} - {{ $checklist->title }}
                            @if($checklist->mod_type === 'room_inspection')
                                <span class="room-progress">5/5 Rooms</span>
                            @endif
                        </div>
                        <span style="margin-left:auto;color:#16a34a;font-weight:700;">Selesai</span>
                    </div>
                @else
                    <div class="checklist-item disabled" style="cursor:not-allowed;">
                        <img src="{{ $checklist->hotel === 'HARRIS' ? asset('assets/harris.png') : asset('assets/pop.png') }}"
                             class="hotel-logo" style="filter: grayscale(1);" alt="">
                        <div class="checklist-title" style="color:#94a3b8;">
                            {{ $checklist->hotel }} - {{ $checklist->title }}
                            @if($checklist->mod_type === 'room_inspection')
                                <span class="room-progress" style="background:#e2e8f0; color:#64748b;">{{ $currentRoomCount }}/5 Rooms</span>
                            @endif
                        </div>
                        @if(!$canAccess && !$completed)
                            <span style="margin-left:auto;color:#94a3b8;font-size:0.85rem;">
                                <i class="fas fa-lock"></i> Locked
                            </span>
                        @endif
                    </div>
                @endif
            @endforeach
        </div>

        {{-- Signature Section --}}
        <div class="signature-section {{ !$allCompleted ? 'signature-disabled' : '' }}">
            <div class="signature-header">
                <i class="fas fa-signature"></i>
                Tanda Tangan Digital
            </div>
            <div class="signature-area {{ !$allCompleted ? 'disabled' : '' }}" id="signature-container">
                <canvas id="signature-pad"></canvas>
                <input type="hidden" id="signature-data" name="signature">
            </div>
            <div class="signature-actions">
                <button type="button" class="btn-signature btn-hapus" id="clear-signature">
                    <i class="fas fa-eraser"></i> Hapus
                </button>
                <button type="button" class="btn-signature btn-simpan" id="save-signature" {{ !$allCompleted ? 'disabled' : '' }}>
                    <i class="fas fa-save"></i> Simpan
                </button>
            </div>
        </div>

        <form id="submit-mod-form" action="{{ route('user.mod.submit') }}" method="POST" style="display: none;">
            @csrf
            <input type="hidden" name="signature" id="signature-input">
        </form>

        <button type="button" id="submit-btn" class="btn-submit {{ $allCompleted ? 'active' : '' }}" {{ !$allCompleted ? 'disabled' : '' }}>
            KIRIM CHECKLIST MOD
        </button>
    </div>
@endif
@endsection

@section('mobile-content')
{{-- Modal yang sama untuk mobile (gunakan ID berbeda atau modal yang sama) --}}
<div id="successModalMobile" class="exit-confirmation-modal" style="display: none;">
    <div class="modal-content" style="text-align: center;">
        <div style="font-size: 4rem; color: #10b981; margin-bottom: 16px;">✓</div>
        <h3 class="modal-title" style="color: #065f46;">Berhasil</h3>
        <p class="modal-message" id="successMessageMobile">Tanda tangan berhasil disimpan!</p>
        <button id="closeSuccessModalMobile" class="modal-btn modal-btn-confirm" style="background: #3b82f6; color: white; border: none; padding: 12px 24px; border-radius: 10px; font-weight: 600; cursor: pointer; min-width: 120px;">OK</button>
    </div>
</div>

<h1 class="dashboard-title">Checklist MOD</h1>

@if(session('success'))
    <div class="success-message" style="margin: 16px; border-radius: 10px;"> {{ session('success') }}</div>
@endif
@if(session('error'))
    <div class="alert-message" style="margin: 16px; border-radius: 10px;"> {{ session('error') }}</div>
@endif

@if(!$isEventDay)
    <div class="empty-state">
        <i class="fas fa-calendar-times"></i>
        <p>MOD tidak tersedia hari ini.</p>
    </div>
@elseif($submitted)
    {{-- Mode readonly mobile --}}
    <div class="empty-state" style="margin-bottom: 20px;">
        <i class="fas fa-check-circle" style="color: #3b82f6;"></i>
        <p style="font-weight: 600;">Anda telah mengirimkan MOD hari ini</p>
        <span style="color: #6b7280;">Menunggu persetujuan admin</span>
    </div>

    <div class="checklist-list" style="opacity: 0.6; pointer-events: none;">
        @foreach($accessibleChecklists as $item)
            @php
                $checklist = $item['checklist'];
                $completed = $item['completed'];
                $modSession = \App\Models\ModSession::where('user_id', auth()->id())
                    ->where('event_date', now()->toDateString())
                    ->where('hotel', $checklist->hotel)
                    ->first();
                $currentRoomCount = $modSession ? $modSession->room_inspection_count : 0;
                $maxRooms = 5;
            @endphp
            <div class="checklist-item disabled" style="background: #f9fafb;">
                <img src="{{ $checklist->hotel === 'HARRIS' ? asset('assets/harris.png') : asset('assets/pop.png') }}"
                     class="hotel-logo" style="filter: grayscale(1);" alt="">
                <div class="checklist-title" style="color: #94a3b8;">
                    {{ $checklist->hotel }} - {{ $checklist->title }}
                    @if($checklist->mod_type === 'room_inspection')
                        <span class="room-progress" style="background:#e2e8f0; color:#64748b;">{{ $currentRoomCount }}/{{ $maxRooms }}</span>
                    @endif
                </div>
                @if($completed)
                    <span style="margin-left:auto; color:#16a34a;">✓ Selesai</span>
                @endif
            </div>
        @endforeach
    </div>

    <div class="signature-section" style="opacity: 0.6; pointer-events: none; margin-top:24px;">
        <div class="signature-header">
            <i class="fas fa-signature"></i>
            Tanda Tangan
        </div>
        <div class="signature-area disabled" style="border-color: #cbd5e1;">
            <canvas id="signature-pad-mobile" style="display: none;"></canvas>
            <div style="text-align: center; color: #64748b; padding: 20px;">
                <i class="fas fa-check-circle" style="color: #10b981; font-size: 2rem;"></i>
                <p style="margin-top: 8px;">Anda sudah mengirimkan tanda tangan</p>
            </div>
        </div>
    </div>
@else
    {{-- Mobile aktif --}}
    <div class="checklist-list">
        @foreach($accessibleChecklists as $item)
            @php
                $checklist = $item['checklist'];
                $canAccess = $item['can_access'];
                $completed = $item['completed'];
                $roomCount = $item['room_count'] ?? 0;
                
                $modSession = \App\Models\ModSession::where('user_id', auth()->id())
                    ->where('event_date', now()->toDateString())
                    ->where('hotel', $checklist->hotel)
                    ->first();
                
                $currentRoomCount = $modSession ? $modSession->room_inspection_count : 0;
                $maxRooms = 5;
                
                if ($completed) {
                    $state = 'done';
                } elseif ($canAccess) {
                    $state = 'active';
                } else {
                    $state = 'locked';
                }
            @endphp

            @if($state === 'active')
                <a href="{{ route('user.checklist.fill', ['checklistId' => $checklist->id, 'step' => 0]) }}"
                   class="checklist-item" style="text-decoration:none; color:inherit;">
                    <img src="{{ $checklist->hotel === 'HARRIS' ? asset('assets/harris.png') : asset('assets/pop.png') }}"
                         class="hotel-logo" alt="">
                    <div class="checklist-title">
                        {{ $checklist->hotel }} - {{ $checklist->title }}
                        @if($checklist->mod_type === 'room_inspection')
                            <span class="room-progress">{{ $currentRoomCount }}/{{ $maxRooms }}</span>
                        @endif
                    </div>
                </a>
            @elseif($state === 'done')
                <div class="checklist-item disabled" style="opacity:.55">
                    <img src="{{ $checklist->hotel === 'HARRIS' ? asset('assets/harris.png') : asset('assets/pop.png') }}"
                         class="hotel-logo" alt="">
                    <div class="checklist-title">
                        {{ $checklist->hotel }} - {{ $checklist->title }}
                        @if($checklist->mod_type === 'room_inspection')
                            <span class="room-progress">{{ $maxRooms }}/{{ $maxRooms }}</span>
                        @endif
                    </div>
                    <span style="margin-left:auto;color:#16a34a;font-weight:700;">Selesai</span>
                </div>
            @else
                <div class="checklist-item disabled">
                    <img src="{{ $checklist->hotel === 'HARRIS' ? asset('assets/harris.png') : asset('assets/pop.png') }}"
                         class="hotel-logo" alt="">
                    <div class="checklist-title">
                        {{ $checklist->hotel }} - {{ $checklist->title }}
                        @if($checklist->mod_type === 'room_inspection')
                            <span class="room-progress">{{ $currentRoomCount }}/{{ $maxRooms }}</span>
                        @endif
                    </div>
                    <span style="margin-left:auto;color:#94a3b8;"></span>
                </div>
            @endif
        @endforeach
    </div>

    <div class="signature-section {{ !$allCompleted ? 'signature-disabled' : '' }}" style="margin-top: 24px;">
        <div class="signature-header">
            <i class="fas fa-signature"></i>
            Tanda Tangan
        </div>
        <div class="signature-area {{ !$allCompleted ? 'disabled' : '' }}" id="signature-container-mobile">
            <canvas id="signature-pad-mobile"></canvas>
            <input type="hidden" id="signature-data-mobile" name="signature">
        </div>
        <div class="signature-actions">
            <button type="button" class="btn-signature btn-hapus" id="clear-signature-mobile">
                <i class="fas fa-eraser"></i> Hapus
            </button>
            <button type="button" class="btn-signature btn-simpan" id="save-signature-mobile" {{ !$allCompleted ? 'disabled' : '' }}>
                <i class="fas fa-save"></i> Simpan
            </button>
        </div>
    </div>

    <form id="submit-mod-form-mobile" action="{{ route('user.mod.submit') }}" method="POST" style="display: none;">
        @csrf
        <input type="hidden" name="signature" id="signature-input-mobile">
    </form>

    <button type="button" id="submit-btn-mobile" class="btn-submit {{ $allCompleted ? 'active' : '' }}" {{ !$allCompleted ? 'disabled' : '' }} style="margin-top: 24px; margin-bottom: 20px;">
        KIRIM CHECKLIST MOD
    </button>
@endif
@endsection

@push('scripts')
    <script src="https://cdn.jsdelivr.net/npm/signature_pad@4.0.0/dist/signature_pad.umd.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Variabel untuk menyimpan status (tidak lagi menyimpan data, karena langsung ke form)
            let isSignatureSaved = false;

            // Fungsi menampilkan modal sukses
            function showSuccessModal(isMobile = false) {
                const modalId = isMobile ? 'successModalMobile' : 'successModal';
                const modal = document.getElementById(modalId);
                if (modal) {
                    modal.style.display = 'flex';
                    document.body.style.overflow = 'hidden';
                }
            }

            // Tutup modal
            document.getElementById('closeSuccessModal')?.addEventListener('click', function() {
                document.getElementById('successModal').style.display = 'none';
                document.body.style.overflow = 'auto';
            });
            document.getElementById('closeSuccessModalMobile')?.addEventListener('click', function() {
                document.getElementById('successModalMobile').style.display = 'none';
                document.body.style.overflow = 'auto';
            });

            // Inisialisasi Signature Pad Desktop
            function initSignatureDesktop() {
                const canvas = document.getElementById('signature-pad');
                if (!canvas || canvas.hasAttribute('data-initialized')) return;
                canvas.setAttribute('data-initialized', 'true');

                const ratio = Math.max(window.devicePixelRatio || 1, 1);
                const rect = canvas.getBoundingClientRect();
                canvas.width = rect.width * ratio;
                canvas.height = rect.height * ratio;
                const ctx = canvas.getContext('2d');
                ctx.scale(ratio, ratio);

                const signaturePad = new SignaturePad(canvas, {
                    backgroundColor: 'rgb(248, 250, 252)',
                    penColor: 'black' // warna hitam
                });

                const area = document.getElementById('signature-container');
                const clearBtn = document.getElementById('clear-signature');
                const saveBtn = document.getElementById('save-signature');
                const submitBtn = document.getElementById('submit-btn');
                const formHiddenInput = document.getElementById('signature-input'); // input di dalam form

                canvas.addEventListener('pointerdown', () => {
                    if (area) area.classList.add('is-drawing');
                });

                canvas.addEventListener('pointerup', () => {
                    if (area && !signaturePad.isEmpty()) {
                        area.classList.remove('is-drawing');
                    }
                });

                if (clearBtn) {
                    clearBtn.addEventListener('click', () => {
                        signaturePad.clear();
                        isSignatureSaved = false;
                        if (area) area.classList.remove('is-drawing');
                        if (submitBtn) {
                            submitBtn.classList.remove('active');
                            submitBtn.disabled = true;
                        }
                        // Kosongkan hidden input form
                        if (formHiddenInput) formHiddenInput.value = '';
                    });
                }

                if (saveBtn) {
                    saveBtn.addEventListener('click', () => {
                        if (!signaturePad.isEmpty()) {
                            const signatureData = signaturePad.toDataURL('image/png');
                            // Langsung simpan ke hidden input form
                            if (formHiddenInput) {
                                formHiddenInput.value = signatureData;
                            }
                            // Simpan juga ke hidden input di area signature (opsional)
                            document.getElementById('signature-data').value = signatureData;
                            
                            isSignatureSaved = true;
                            
                            if (submitBtn) {
                                submitBtn.classList.add('active');
                                submitBtn.disabled = false;
                            }
                            
                            if (area) area.classList.remove('is-drawing');
                            
                            showSuccessModal(false);
                        } else {
                            alert('Silakan buat tanda tangan terlebih dahulu.');
                        }
                    });
                }

                if (submitBtn) {
                    submitBtn.addEventListener('click', () => {
                        // Cek apakah hidden input sudah terisi
                        if (formHiddenInput && formHiddenInput.value.trim() !== '') {
                            document.getElementById('submit-mod-form').submit();
                        } else {
                            alert('Silakan simpan tanda tangan terlebih dahulu.');
                        }
                    });
                }
            }

            // Inisialisasi Signature Pad Mobile (sama persis, dengan ID berbeda)
            function initSignatureMobile() {
                const canvas = document.getElementById('signature-pad-mobile');
                if (!canvas || canvas.hasAttribute('data-initialized')) return;
                canvas.setAttribute('data-initialized', 'true');

                const ratio = Math.max(window.devicePixelRatio || 1, 1);
                const rect = canvas.getBoundingClientRect();
                canvas.width = rect.width * ratio;
                canvas.height = rect.height * ratio;
                const ctx = canvas.getContext('2d');
                ctx.scale(ratio, ratio);

                const signaturePad = new SignaturePad(canvas, {
                    backgroundColor: 'rgb(248, 250, 252)',
                    penColor: 'black'
                });

                const area = document.getElementById('signature-container-mobile');
                const clearBtn = document.getElementById('clear-signature-mobile');
                const saveBtn = document.getElementById('save-signature-mobile');
                const submitBtn = document.getElementById('submit-btn-mobile');
                const formHiddenInput = document.getElementById('signature-input-mobile');

                canvas.addEventListener('pointerdown', () => {
                    if (area) area.classList.add('is-drawing');
                });

                canvas.addEventListener('pointerup', () => {
                    if (area && !signaturePad.isEmpty()) {
                        area.classList.remove('is-drawing');
                    }
                });

                if (clearBtn) {
                    clearBtn.addEventListener('click', () => {
                        signaturePad.clear();
                        if (area) area.classList.remove('is-drawing');
                        if (submitBtn) {
                            submitBtn.classList.remove('active');
                            submitBtn.disabled = true;
                        }
                        if (formHiddenInput) formHiddenInput.value = '';
                    });
                }

                if (saveBtn) {
                    saveBtn.addEventListener('click', () => {
                        if (!signaturePad.isEmpty()) {
                            const signatureData = signaturePad.toDataURL('image/png');
                            if (formHiddenInput) {
                                formHiddenInput.value = signatureData;
                            }
                            document.getElementById('signature-data-mobile').value = signatureData;
                            
                            if (submitBtn) {
                                submitBtn.classList.add('active');
                                submitBtn.disabled = false;
                            }
                            
                            if (area) area.classList.remove('is-drawing');
                            
                            showSuccessModal(true);
                        } else {
                            alert('Silakan buat tanda tangan terlebih dahulu.');
                        }
                    });
                }

                if (submitBtn) {
                    submitBtn.addEventListener('click', () => {
                        if (formHiddenInput && formHiddenInput.value.trim() !== '') {
                            document.getElementById('submit-mod-form-mobile').submit();
                        } else {
                            alert('Silakan simpan tanda tangan terlebih dahulu.');
                        }
                    });
                }
            }

            // Cek status dari server
            const submitted = {{ isset($submitted) && $submitted ? 'true' : 'false' }};
            const allCompleted = {{ $allCompleted ? 'true' : 'false' }};

            if (!submitted && allCompleted) {
                initSignatureDesktop();
                initSignatureMobile();
            }
        });
    </script>
@endpush