@extends('layouts.UserLayout')

@push('styles')
<style>
    /* ================= COMMON STYLES ================= */
    .dashboard-title {
        font-size: 1.75rem;
        font-weight: 800;
        margin-bottom: 24px;
        color: #0f2a4d;
        text-align: center;
        position: relative;
    }

    .dashboard-title::after {
        content: '';
        display: block;
        width: 60px;
        height: 4px;
        background: linear-gradient(to right, #3b82f6, #5d8fd9);
        margin: 10px auto 0;
        border-radius: 2px;
    }

    .checklist-list {
        display: flex;
        flex-direction: column;
        gap: 20px;
    }

    .checklist-item {
        background: white;
        border-radius: 16px;
        padding: 20px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        border: 1px solid #e2e8f0;
        position: relative;
        overflow: hidden;
    }

    .checklist-item.completed::before {
        background: linear-gradient(to bottom, #10b981, #059669) !important;
        opacity: 1 !important;
    }

    .checklist-item.in-progress::before {
        background: linear-gradient(to bottom, #3b82f6, #1d4ed8) !important;
        opacity: 1 !important;
    }

    .checklist-item::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 5px;
        height: 100%;
        background: linear-gradient(to bottom, #f59e0b, #d97706);
        opacity: 0;
        transition: opacity 0.3s ease;
    }

    .checklist-icon {
        width: 48px;
        height: 48px;
        background: #f8fafc;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 16px;
        flex-shrink: 0;
        color: #64748b;
        font-size: 1.2rem;
    }

    .checklist-info {
        flex-grow: 1;
        min-width: 0;
    }

    .checklist-hotel {
        font-weight: 700;
        font-size: 1.05rem;
        color: #0f2a4d;
        margin-bottom: 4px;
        display: flex;
        align-items: center;
        gap: 6px;
    }

    .hotel-tag {
        font-size: 0.75rem;
        padding: 2px 8px;
        border-radius: 20px;
        background: #dbeafe;
        color: #1d4ed8;
        font-weight: 600;
    }

    .checklist-title {
        font-weight: 600;
        font-size: 0.95rem;
        color: #475569;
        margin-bottom: 12px;
        word-wrap: break-word;
    }

    .status-badge {
        font-size: 0.85rem;
        font-weight: 600;
        padding: 4px 10px;
        border-radius: 20px;
        white-space: nowrap;
    }

    .status-not-started {
        color: #dc2626;
        background: #fee2e2;
    }

    .status-in-progress {
        color: #1d4ed8;
        background: #dbeafe;
    }

    .status-completed {
        color: #059669;
        background: #dcfce7;
    }

    .completion-date {
        font-size: 0.8rem;
        color: #64748b;
        white-space: nowrap;
    }

    .view-more-btn {
        font-size: 0.8rem;
        color: #3b82f6;
        font-weight: 600;
        text-decoration: none;
        padding: 4px 8px;
        border-radius: 6px;
        background: #eff6ff;
        transition: background 0.2s;
        white-space: nowrap;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        gap: 4px;
    }

    .view-more-btn:hover {
        background: #dbeafe;
    }

    .empty-state {
        text-align: center;
        padding: 60px 20px 40px;
        color: #64748b;
    }

    .empty-state i {
        font-size: 3rem;
        color: #10b981;
        margin-bottom: 16px;
        opacity: 0.8;
    }

    .empty-state h3 {
        font-size: 1.3rem;
        font-weight: 700;
        color: #0f172a;
        margin-bottom: 10px;
    }

    .empty-state p {
        font-size: 0.95rem;
        color: #64748b;
    }

    /* ================= ALL COMPLETED BANNER ================= */
    .all-completed-banner {
        background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        color: white;
        padding: 20px;
        border-radius: 12px;
        margin-bottom: 25px;
        text-align: center;
        box-shadow: 0 6px 15px rgba(16, 185, 129, 0.3);
        animation: fadeIn 0.5s ease;
    }

    .all-completed-banner h3 {
        margin: 0 0 10px 0;
        font-size: 1.3rem;
        font-weight: 700;
    }

    .all-completed-banner p {
        margin: 0 0 15px 0;
        opacity: 0.9;
        font-size: 0.95rem;
    }

    .review-all-btn {
        background: white;
        color: #059669;
        padding: 10px 24px;
        border-radius: 8px;
        font-weight: 600;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        transition: transform 0.2s, box-shadow 0.2s;
    }

    .review-all-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(255, 255, 255, 0.2);
        color: #059669;
    }

    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(-10px); }
        to { opacity: 1; transform: translateY(0); }
    }

    /* ================= DESKTOP SECTION STYLES ================= */
    .desktop-section {
        max-width: 1200px;
        margin: 0 auto;
        padding: 20px;
    }

    .desktop-checklist-item {
        display: flex;
        align-items: flex-start;
    }

    .desktop-checklist-status-row {
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
    }

    .desktop-status-left {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .desktop-status-right {
        display: flex;
        align-items: center;
        gap: 15px;
        flex-shrink: 0;
    }

    /* ================= MOBILE SECTION STYLES ================= */
    .mobile-section {
        padding: 16px;
        padding-bottom: 100px;
        background: #f8fafc;
        min-height: 100vh;
    }

    .mobile-checklist-item {
        display: flex;
        align-items: flex-start;
    }

    .mobile-checklist-status-row {
        display: flex;
        flex-direction: column;
        gap: 10px;
    }

    .mobile-status-top {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .mobile-status-bottom {
        display: flex;
        justify-content: space-between;
        align-items: center;
        gap: 10px;
        margin-top: 8px;
    }

    .mobile-completion-date {
        font-size: 0.75rem;
        color: #64748b;
    }

    /* ================= RESPONSIVE HIDING ================= */
    @media (min-width: 1024px) {
        .mobile-section {
            display: none !important;
        }
        .desktop-section {
            display: block !important;
        }
    }

    @media (max-width: 1023px) {
        .desktop-section {
            display: none !important;
        }
        .mobile-section {
            display: block !important;
        }
        
        .dashboard-title {
            font-size: 1.5rem;
            margin-bottom: 20px;
            padding-top: 20px;
        }
        
        .checklist-item {
            padding: 16px;
            border-radius: 14px;
        }
        
        .checklist-icon {
            width: 42px;
            height: 42px;
            font-size: 1.1rem;
            margin-right: 12px;
        }
        
        .checklist-hotel {
            font-size: 1rem;
        }
        
        .checklist-title {
            font-size: 0.9rem;
        }
        
        .status-badge {
            font-size: 0.75rem;
            padding: 3px 8px;
        }
        
        .completion-date, .view-more-btn {
            font-size: 0.75rem;
        }
        
        .view-more-btn {
            padding: 3px 6px;
        }
        
        .all-completed-banner {
            padding: 16px;
            margin-bottom: 20px;
        }
        
        .all-completed-banner h3 {
            font-size: 1.1rem;
        }
        
        .all-completed-banner p {
            font-size: 0.85rem;
        }
        
        .review-all-btn {
            padding: 8px 16px;
            font-size: 0.9rem;
        }
    }
</style>
@endpush

{{-- ================= DESKTOP SECTION ================= --}}
@section('content')
<div class="desktop-section">
    <h1 class="dashboard-title">Status MOD Hari Ini</h1>

    @php
        $hasActiveMod = collect($modList)->contains('is_active', true);
    @endphp

    @if($hasActiveMod)
        <div class="checklist-list">
            @foreach($modList as $mod)
                @if(!$mod['is_active']) @continue @endif

                @php
                    $class = match($mod['status']) {
                        'completed' => 'completed',
                        'in_progress' => 'in-progress',
                        default => ''
                    };
                @endphp

                <div class="checklist-item desktop-checklist-item {{ $class }}">
                    <div class="checklist-icon">
                        @if($mod['mod_type'] === 'general')
                            <i class="fas fa-building"></i>
                        @else
                            <i class="fas fa-bed"></i>
                        @endif
                    </div>
                    <div class="checklist-info">
                        <div class="checklist-hotel">
                            {{ $mod['hotel'] }}
                            <span class="hotel-tag">
                                {{ $mod['mod_type'] === 'general' ? 'General Operation' : 'Room Inspection' }}
                            </span>
                        </div>
                        <div class="checklist-title">{{ $mod['label'] }}</div>
                        <div class="desktop-checklist-status-row">
                            <div class="desktop-status-left">
                                @if($mod['is_completed'])
                                    <span class="status-badge status-completed">
                                        <i class="fas fa-check-circle"></i> Selesai
                                    </span>
                                @elseif($mod['status'] === 'in_progress')
                                    <span class="status-badge status-in-progress">
                                        <i class="fas fa-spinner"></i> In Progress
                                    </span>
                                @else
                                    <span class="status-badge status-not-started">
                                        <i class="fas fa-clock"></i> Belum Dimulai
                                    </span>
                                @endif
                            </div>
                            
                            <div class="desktop-status-right">
                                @if($mod['completed_at'])
                                    <span class="completion-date">
                                        {{ \Carbon\Carbon::parse($mod['completed_at'])->format('d M Y') }}
                                    </span>
                                @endif
                                
                                {{-- 🔥 TOMBOL VIEW SUMMARY HANYA MUNCUL JIKA SEMUA MOD SELESAI --}}
                                @if($allModsCompleted && $mod['is_completed'])
                                    <a href="{{ route('user.checklist.review', ['checklistId' => $mod['checklist_id']]) }}" 
                                       class="view-more-btn">
                                        <i class="fas fa-eye"></i> View Summary
                                    </a>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    @else
        <div class="empty-state">
            <i class="fas fa-calendar-times"></i>
            <h3>Tidak Ada Jadwal MOD Hari Ini</h3>
            <p>MOD hanya tersedia pada tanggal event yang telah dijadwalkan oleh manajemen.</p>
        </div>
    @endif
</div>
@endsection

{{-- ================= MOBILE SECTION ================= --}}
@section('mobile-content')
<div class="mobile-section">
    <h1 class="dashboard-title">Status MOD Hari Ini</h1>

    @php
        $hasActiveMod = collect($modList)->contains('is_active', true);
    @endphp

    @if($hasActiveMod)
        <div class="checklist-list">
            @foreach($modList as $mod)
                @if(!$mod['is_active']) @continue @endif

                @php
                    $class = match($mod['status']) {
                        'completed' => 'completed',
                        'in_progress' => 'in-progress',
                        default => ''
                    };
                @endphp

                <div class="checklist-item mobile-checklist-item {{ $class }}">
                    <div class="checklist-icon">
                        @if($mod['mod_type'] === 'general')
                            <i class="fas fa-building"></i>
                        @else
                            <i class="fas fa-bed"></i>
                        @endif
                    </div>
                    <div class="checklist-info">
                        <div class="checklist-hotel">
                            {{ $mod['hotel'] }}
                            <span class="hotel-tag">
                                {{ $mod['mod_type'] === 'general' ? 'General' : 'Room' }}
                            </span>
                        </div>
                        <div class="checklist-title">{{ $mod['label'] }}</div>
                        <div class="mobile-checklist-status-row">
                            <div class="mobile-status-top">
                                @if($mod['is_completed'])
                                    <span class="status-badge status-completed">
                                        <i class="fas fa-check-circle"></i> Selesai
                                    </span>
                                @elseif($mod['status'] === 'in_progress')
                                    <span class="status-badge status-in-progress">
                                        <i class="fas fa-spinner"></i> In Progress
                                    </span>
                                @else
                                    <span class="status-badge status-not-started">
                                        <i class="fas fa-clock"></i> Belum Dimulai
                                    </span>
                                @endif
                            </div>
                            
                            <div class="mobile-status-bottom">
                                @if($mod['completed_at'])
                                    <span class="mobile-completion-date">
                                        {{ \Carbon\Carbon::parse($mod['completed_at'])->format('d M Y') }}
                                    </span>
                                @endif
                                
                                @if($allModsCompleted && $mod['is_completed'])
                                    <a href="{{ route('user.checklist.review', ['checklistId' => $mod['checklist_id']]) }}" 
                                       class="view-more-btn">
                                        <i class="fas fa-eye"></i> Summary
                                    </a>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    @else
        <div class="empty-state">
            <i class="fas fa-calendar-times"></i>
            <h3>Tidak Ada Jadwal MOD</h3>
            <p>MOD hanya tersedia pada tanggal event yang terdaftar.</p>
        </div>
    @endif
</div>
@endsection