<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Harris Pop</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            margin: 0;
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            background: linear-gradient(135deg, #0a1e3a, #0f2a4d);
            color: #f1f5f9;
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            overflow: hidden;
        }

        .splash {
            text-align: center;
            padding: 0 1.5rem;
            max-width: 100%;
            position: relative;
        }

        /* ========== Logo Container ========== */
        .logo-container {
            position: relative;
            margin-bottom: 2.2rem;
        }

        .logo {
            max-width: 80vw;
            max-height: 40vh;
            height: auto;
            opacity: 0;
            transform: scale(0.85) translateY(20px);
            animation: logoAppear 0.9s ease-out forwards;
        }

        /* Fallback jika gambar gagal dimuat */
        .logo-fallback {
            display: none;
            font-size: clamp(2rem, 8vw, 3.5rem);
            font-weight: 700;
            background: linear-gradient(90deg, #6ba8f0, #ffffff);
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
            opacity: 0;
            animation: logoAppear 0.9s ease-out 0.1s forwards;
        }

        /* ========== Divider Line ========== */
        .divider {
            width: 60px;
            height: 3px;
            background: #5d8fd9;
            margin: 0 auto 2rem;
            border-radius: 3px;
            opacity: 0;
            transform: scaleX(0);
            transform-origin: center;
            animation: lineGrow 0.8s ease-out 0.4s forwards;
        }

        /* ========== Loading Text ========== */
        .loading {
            font-size: clamp(1rem, 4vw, 1.15rem);
            font-weight: 500;
            color: #cbd5e1;
            opacity: 0;
            animation: fade 0.6s ease-out 0.7s forwards;
        }

        .dots {
            display: inline-block;
        }

        .dots::after {
            content: '';
            animation: dots 1.5s infinite;
        }

        /* ========== Animations ========== */
        @keyframes logoAppear {
            to {
                opacity: 1;
                transform: scale(1) translateY(0);
            }
        }

        @keyframes lineGrow {
            to {
                opacity: 1;
                transform: scaleX(1);
            }
        }

        @keyframes fade {
            to {
                opacity: 1;
            }
        }

        @keyframes dots {
            0%, 20% { content: '.'; }
            40% { content: '..'; }
            60%, 100% { content: '...'; }
        }

        /* ========== Fade-out saat redirect ========== */
        .fade-out {
            opacity: 0;
            transform: scale(0.98);
            transition: opacity 0.4s ease, transform 0.4s ease;
        }

        /* ========== Responsive ========== */
        @media (max-width: 600px) {
            .logo {
                max-width: 70vw;
                max-height: 35vh;
            }
            .divider {
                width: 50px;
                margin-bottom: 1.5rem;
            }
            .loading {
                font-size: clamp(0.9rem, 5vw, 1rem);
            }
        }

        @media (max-width: 360px) {
            .logo {
                max-width: 65vw;
            }
        }
    </style>
</head>
<body>
    <div class="splash">
        <div class="logo-container">
            <img
                src="{{ asset('assets/logoo.png') }}"
                alt="Harris Pop"
                class="logo"
                id="logo"
                onerror="this.style.display='none'; document.getElementById('fallback').style.display='block';"
            >
            <div class="logo-fallback" id="fallback">HARRIS POP</div>
        </div>
        <div class="divider"></div>
        <div class="loading">Memuat aplikasi<span class="dots"></span></div>
    </div>

    <script>
        // Preload logo (opsional tapi disarankan)
        const logo = new Image();
        logo.src = "{{ asset('assets/logoo.png') }}";

        // Redirect dengan fade-out halus
        setTimeout(() => {
            document.body.classList.add('fade-out');
            // Tunggu animasi selesai sebelum redirect
            setTimeout(() => {
                window.location.href = '/wlcm';
            }, 400);
        }, 2000);
    </script>
</body>
</html>
