<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Login · Harris Pop</title>
    <link rel="stylesheet" href="{{ asset('assets/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/vendor/fontawesome/css/all.min.css') }}">
    <style>
        /* Root & body */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Inter', system-ui, -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(145deg, #f0f5ff 0%, #e6edfa 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 1rem;
            margin: 0;
            color: #1e293b;
        }
        .auth-wrapper {
            width: 100%;
            max-width: 935px; /* 15% lebih kecil dari 1100px */
        }
        .card-auth {
            background: rgba(255,255,255,0.9);
            backdrop-filter: blur(4px);
            border-radius: 2rem; /* sedikit lebih kecil */
            box-shadow: 0 20px 40px -12px rgba(0,0,0,0.15);
            overflow: hidden;
            border: 1px solid rgba(255,255,255,0.5);
        }
        .illustration-col {
            background: linear-gradient(135deg, #1e3c8f 0%, #2b4b9a 100%);
            padding: 2.5rem 1.5rem; 
            color: white;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            text-align: center;
            min-height: 470px; /* turun 15% dari 550px */
        }
        .illustration-col h2 {
            font-weight: 700;
            font-size: 1.8rem; 
            margin-bottom: 0.75rem;
            letter-spacing: -0.02em;
        }
        .illustration-col p {
            font-size: 0.9rem;
            opacity: 0.9;
            max-width: 240px;
        }
        .form-col {
            background: white;
            padding: 2rem 1.5rem; 
        }
       
        .logo-wrapper {
            text-align: center;
            margin-bottom: 1.2rem;
        }
        .logo-wrapper img {
            max-height: 50px; 
            width: auto;
        }
        .title {
            font-size: 1.5rem; 
            font-weight: 700;
            color: #0f172a;
            margin-bottom: 0.25rem;
            text-align: center;
        }
        .subtitle {
            color: #64748b;
            font-size: 0.85rem; 
            margin-bottom: 1.5rem; 
            text-align: center;
            border-left: 3px solid #f97316;
            padding-left: 0.75rem;
            margin-left: auto;
            margin-right: auto;
            max-width: fit-content;
        }
        .alert {
            border-radius: 0.9rem;
            font-size: 0.85rem;
            padding: 0.75rem 1rem;
            border: none;
            margin-bottom: 1.2rem;
        }
        .alert-danger {
            background: #fee2e2;
            color: #b91c1c;
        }
        .alert-success {
            background: #dcfce7;
            color: #166534;
        }
        .field {
            position: relative;
            margin-bottom: 1.2rem; 
        }
        .field input,
        .field select {
            width: 100%;
            height: 46px; /* turun 15% */
            padding: 0 0.75rem 0 2.5rem; /* icon lebih kecil */
            font-size: 0.9rem; 
            border: 1.5px solid #e2e8f0;
            border-radius: 12px; 
            background: #f8fafc;
            transition: all 0.2s ease;
            color: #1e293b;
        }
        .field input:focus,
        .field select:focus {
            outline: none;
            border-color: #1e3c8f;
            background: #ffffff;
            box-shadow: 0 4px 8px rgba(30, 60, 143, 0.1);
        }
        /* Placeholder styling */
        .field input::placeholder,
        .field select::placeholder {
            color: #cbd5e1; /* warna terang agar terlihat */
            opacity: 1;
            font-size: 0.9rem;
        }
        .field i.icon {
            position: absolute;
            left: 0.85rem; /* disesuaikan */
            top: 50%;
            transform: translateY(-50%);
            color: #94a3b8;
            font-size: 1rem; 
            transition: color 0.2s;
        }
        .field input:focus ~ i.icon {
            color: #1e3c8f;
        }
        .field label {
            position: absolute;
            top: 50%;
            left: 2.5rem; /* disesuaikan */
            transform: translateY(-50%);
            font-size: 0.85rem; 
            color: #94a3b8;
            pointer-events: none;
            transition: 0.2s;
            background: linear-gradient(to top, #f8fafc 50%, transparent 50%);
            padding: 0 4px;
            opacity: 0;
            visibility: hidden;
        }
        .field input:focus ~ label,
        .field input:not(:placeholder-shown) ~ label,
        .field select:focus ~ label,
        .field select:valid ~ label {
            top: 0px;
            transform: translateY(-50%);
            font-size: 0.7rem; 
            color: #1e3c8f;
            font-weight: 600;
            opacity: 1;
            visibility: visible;
            background: linear-gradient(to top, #ffffff 50%, #ffffff 50%);
            left: 2.2rem; /* disesuaikan */
        }
        .password-toggle {
            position: absolute;
            right: 0.85rem; /* disesuaikan */
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: #94a3b8;
            z-index: 2;
            background: transparent;
            border: none;
            font-size: 0.95rem; 
        }
        .password-toggle:hover {
            color: #1e3c8f;
        }
        .remember-me {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            margin: 1rem 0 1.5rem; 
            font-size: 0.85rem; 
            color: #334155;
        }
        .remember-me input[type="checkbox"] {
            width: 1rem;
            height: 1rem;
            accent-color: #1e3c8f;
            border-radius: 4px;
        }
        .btn-primary {
            width: 100%;
            height: 46px; /* turun 15% */
            background: #1e3c8f;
            color: white;
            border: none;
            border-radius: 12px; 
            font-size: 0.95rem; 
            font-weight: 600;
            cursor: pointer;
            transition: background 0.2s, transform 0.1s;
            box-shadow: 0 6px 12px -4px rgba(30, 60, 143, 0.3);
        }
        .btn-primary:hover {
            background: #15306b;
        }
        .btn-primary:active {
            transform: scale(0.98);
        }
        .form-footer {
            text-align: center;
            margin-top: 1.5rem; 
            font-size: 0.85rem; 
            color: #64748b;
        }
        .form-footer a {
            color: #1e3c8f;
            font-weight: 600;
            text-decoration: none;
            border-bottom: 2px solid transparent;
            transition: border-color 0.2s;
        }
        .form-footer a:hover {
            border-bottom-color: #1e3c8f;
        }
        #signupForm {
            display: none;
        }
        /* mobile adjustments */
        @media (max-width: 767px) {
            .illustration-col {
                min-height: auto;
                padding: 1.5rem 1rem;
            }
            .form-col {
                padding: 1.5rem 1rem;
            }
            .title {
                font-size: 1.3rem;
            }
        }
    </style>
</head>
<body>
    <div class="auth-wrapper">
        <div class="card-auth row g-0">
            <!-- Illustration column (desktop) -->
            <div class="col-md-6 illustration-col d-none d-md-flex">
                <div class="px-3">
                    <h2>Welcome Back!<br>To MODify</h2>
                    <!-- <p class="mb-4">Access exclusive features and manage your account with ease.</p>
                    <div class="mt-4">
                        <i class="fas fa-shield-alt fa-2x mb-3" style="opacity:0.8;"></i>
                        <p style="font-size:0.85rem;">Two‑layer security with Google Authenticator.</p>
                    </div> -->
                </div>
            </div>
            <!-- Form column -->
            <div class="col-md-6 form-col">
                <!-- Logo -->
                <div class="logo-wrapper">
                    <img src="{{ asset('assets/logoo.png') }}" alt="Harris Pop" onerror="this.src='https://via.placeholder.com/130x42?text=Harris+Pop'">
                </div>

                <!-- LOGIN FORM -->
                <form id="signinForm" method="POST" action="{{ route('login') }}">
                    @csrf
                    <div class="title">Sign In</div>
                    <div class="subtitle">Please sign in to your account</div>

                    @if(session('success'))
                        <div class="alert alert-success">{{ session('success') }}</div>
                    @endif

                    @if($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0 ps-3">
                                @foreach($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <div class="field">
                        <input type="email" name="email" id="loginEmail" placeholder="Email Address" required value="{{ old('email') }}">
                        <i class="fas fa-envelope icon"></i>
                        <label for="loginEmail">Email Address</label>
                    </div>

                    <div class="field">
                        <input type="password" name="password" id="loginPassword" placeholder="Password" required>
                        <i class="fas fa-lock icon"></i>
                        <label for="loginPassword">Password</label>
                        <span class="password-toggle" onclick="togglePassword('loginPassword')">
                            <i class="fas fa-eye"></i>
                        </span>
                    </div>

                    <div class="remember-me">
                        <input type="checkbox" name="remember" id="rememberMe">
                        <label for="rememberMe">Remember me</label>
                    </div>

                    <button type="submit" class="btn-primary">Sign In</button>

                    <div class="form-footer">
                        Don't have an account? <a href="#" id="showSignup">Register now</a>
                    </div>
                </form>

                <!-- REGISTER FORM -->
                <form id="signupForm" method="POST" action="{{ route('register') }}">
                    @csrf
                    <div class="title">Create Account</div>
                    <div class="subtitle">Register to get started</div>

                    @if($errors->has('register'))
                        <div class="alert alert-danger">{{ $errors->first('register') }}</div>
                    @endif

                    <div class="field">
                        <input type="text" name="name" id="registerName" placeholder="Full Name" required value="{{ old('name') }}">
                        <i class="fas fa-user icon"></i>
                        <label for="registerName">Full Name</label>
                    </div>

                    <div class="field">
                        <input type="email" name="email" id="registerEmail" placeholder="Email" required value="{{ old('email') }}">
                        <i class="fas fa-envelope icon"></i>
                        <label for="registerEmail">Email</label>
                    </div>

                    <div class="field">
                        <input type="password" name="password" id="registerPassword" placeholder="Password" required>
                        <i class="fas fa-lock icon"></i>
                        <label for="registerPassword">Password</label>
                        <span class="password-toggle" onclick="togglePassword('registerPassword')">
                            <i class="fas fa-eye"></i>
                        </span>
                    </div>

                    <div class="field">
                        <input type="password" name="password_confirmation" id="registerPasswordConfirm" placeholder="Confirm Password" required>
                        <i class="fas fa-lock icon"></i>
                        <label for="registerPasswordConfirm">Confirm Password</label>
                        <span class="password-toggle" onclick="togglePassword('registerPasswordConfirm')">
                            <i class="fas fa-eye"></i>
                        </span>
                    </div>

                    <div class="field">
                        <select name="role" id="registerRole" required>
                            <option value="" disabled selected>Select role</option>
                            <option value="User" {{ old('role') == 'User' ? 'selected' : '' }}>User</option>
                            <option value="Admin" {{ old('role') == 'Admin' ? 'selected' : '' }}>Admin</option>
                        </select>
                        <i class="fas fa-user-tag icon"></i>
                        <label for="registerRole">Role</label>
                    </div>

                    <button type="submit" class="btn-primary">Create Account</button>

                    <div class="form-footer">
                        Already have an account? <a href="#" id="showSignin">Sign in</a>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Toggle password visibility
            window.togglePassword = function(inputId) {
                const input = document.getElementById(inputId);
                const icon = input.parentNode.querySelector('.password-toggle i');
                if (input.type === 'password') {
                    input.type = 'text';
                    icon.classList.remove('fa-eye');
                    icon.classList.add('fa-eye-slash');
                } else {
                    input.type = 'password';
                    icon.classList.remove('fa-eye-slash');
                    icon.classList.add('fa-eye');
                }
            };

            // Toggle form login/register
            const signinForm = document.getElementById('signinForm');
            const signupForm = document.getElementById('signupForm');
            const showSignup = document.getElementById('showSignup');
            const showSignin = document.getElementById('showSignin');

            if (showSignup) {
                showSignup.addEventListener('click', function(e) {
                    e.preventDefault();
                    signinForm.style.display = 'none';
                    signupForm.style.display = 'block';
                });
            }

            if (showSignin) {
                showSignin.addEventListener('click', function(e) {
                    e.preventDefault();
                    signupForm.style.display = 'none';
                    signinForm.style.display = 'block';
                });
            }

            // Floating label fix for select (already handled by CSS)
        });
    </script>
</body>
</html>