<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover">
    <title>Status Akun Admin</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        /* Full screen tanpa margin */
        html, body {
            height: 100%;
            overflow: hidden;
        }

        body {
            background: linear-gradient(135deg, #e6f4ff, #d1e7ff);
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 0;
        }

        .container {
            width: 100%;
            height: 100%;
            max-width: 100%;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .card {
            width: 100%;
            height: 100%;
            max-width: 100%;
            background: white;
            box-shadow: none; /* Hilangkan shadow di full screen */
            overflow: hidden;
            display: flex;
            flex-direction: column;
        }

        /* ========== MOBILE: VERTIKAL FULL SCREEN ========== */
        .card-content {
            display: flex;
            flex-direction: column;
            height: 100%;
        }

        .left-panel, .right-panel {
            padding: 20px 16px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
        }

        .left-panel {
            background: linear-gradient(135deg, #0f172a, #1e293b);
            color: white;
            text-align: center;
            position: relative;
            flex-shrink: 0;
            padding-top: 32px;
            padding-bottom: 24px;
        }

        .left-panel::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(59, 130, 246, 0.1) 0%, transparent 70%);
            z-index: 0;
        }

        .left-content {
            position: relative;
            z-index: 1;
            text-align: center;
        }

        .header-icon {
            width: 76px;
            height: 76px;
            background: rgba(59, 130, 246, 0.15);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 24px;
            border: 2px solid rgba(59, 130, 246, 0.3);
        }

        .header-icon i {
            font-size: 2.4rem;
            color: #60a5fa;
            text-shadow: 0 0 12px rgba(59, 130, 246, 0.5);
        }

        .user-name {
            font-size: 1.7rem;
            font-weight: 700;
            margin-bottom: 8px;
            letter-spacing: -0.5px;
        }

        .user-role {
            font-size: 0.95rem;
            opacity: 0.9;
            line-height: 1.5;
        }

        .right-panel {
            flex-grow: 1;
            text-align: center;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            padding: 24px 16px;
        }

        .status-box {
            background: #fff9db;
            border: 1px solid #e2d07a;
            border-radius: 14px;
            padding: 26px 20px;
            margin-bottom: 28px;
            position: relative;
            overflow: hidden;
            flex-shrink: 0;
            width: 100%;
            max-width: 400px;
        }

        .status-box::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, #ffc107, #ff9800);
        }

        .status-title {
            font-size: 1.2rem;
            font-weight: 700;
            color: #856404;
            margin-bottom: 16px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }

        .status-title i {
            color: #ffc107;
            font-size: 1.3rem;
        }

        .status-text {
            font-size: 2.1rem;
            font-weight: 800;
            color: #856404;
            margin-bottom: 16px;
            letter-spacing: 1px;
            text-shadow: 0 1px 2px rgba(133, 100, 4, 0.1);
        }

        .status-description {
            color: #6c757d;
            font-size: 0.95rem;
            line-height: 1.6;
            max-width: 360px;
            margin: 0 auto;
        }

        .logout-btn {
            background: linear-gradient(135deg, #ef4444, #dc2626);
            color: white;
            border: none;
            border-radius: 14px;
            padding: 16px 30px;
            font-size: 1.1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 12px;
            box-shadow: 0 6px 14px rgba(239, 68, 68, 0.35);
            position: relative;
            overflow: hidden;
            flex-shrink: 0;
        }

        .logout-btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: 0.5s;
        }

        .logout-btn:hover::before {
            left: 100%;
        }

        .logout-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 18px rgba(239, 68, 68, 0.45);
        }

        .footer {
            padding: 20px 0 12px;
            text-align: center;
            color: #64748b;
            font-size: 0.85rem;
            margin-top: auto;
        }

        /* Animasi */
        @keyframes float {
            0% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-10px) rotate(2deg); }
            100% { transform: translateY(0px) rotate(0deg); }
        }

        @keyframes pulse {
            0% { box-shadow: 0 0 0 0 rgba(255, 193, 7, 0.4); }
            70% { box-shadow: 0 0 0 12px rgba(255, 193, 7, 0); }
            100% { box-shadow: 0 0 0 0 rgba(255, 193, 7, 0); }
        }

        .header-icon {
            animation: float 4s ease-in-out infinite;
        }

        .status-text {
            animation: pulse 2s infinite;
        }

        /* ========== DESKTOP: HORIZONTAL FULL SCREEN ========== */
        @media (min-width: 768px) {
            .card {
                border-radius: 0;
                box-shadow: 0 0 40px rgba(0, 0, 0, 0.08);
                flex-direction: row;
            }

            .card-content {
                flex-direction: row;
                height: 100%;
                width: 100%;
                max-width: 1400px;
                margin: 0 auto;
            }

            .left-panel {
                flex: 1;
                border-radius: 0;
                padding: 60px 40px;
                display: flex;
                flex-direction: column;
                justify-content: center;
                align-items: center;
            }

            .right-panel {
                flex: 1.3;
                padding: 60px 40px;
                display: flex;
                flex-direction: column;
                justify-content: center;
                align-items: center;
                border-left: 1px solid #e2e8f0;
            }

            /* Sesuaikan ukuran */
            .header-icon {
                width: 110px;
                height: 110px;
                margin-bottom: 32px;
            }

            .header-icon i {
                font-size: 3.2rem;
            }

            .user-name {
                font-size: 2.5rem;
            }

            .user-role {
                font-size: 1.2rem;
            }

            .status-box {
                padding: 36px 32px;
                margin-bottom: 36px;
                border-radius: 16px;
                max-width: 500px;
            }

            .status-title {
                font-size: 1.5rem;
            }

            .status-text {
                font-size: 3.2rem;
            }

            .status-description {
                font-size: 1.1rem;
                line-height: 1.7;
            }

            .logout-btn {
                padding: 18px 40px;
                font-size: 1.2rem;
                border-radius: 16px;
                gap: 14px;
            }

            .footer {
                padding: 24px 0 0;
                font-size: 0.95rem;
            }

            /* Hover effect */
            .card:hover {
                box-shadow: 0 0 50px rgba(0, 0, 0, 0.12);
            }
        }

        /* Extra large desktop (2K/4K) */
        @media (min-width: 1600px) {
            .left-panel, .right-panel {
                padding: 80px 60px;
            }

            .user-name {
                font-size: 2.8rem;
            }

            .status-text {
                font-size: 3.5rem;
            }
        }

        /* Animasi spin */
        .logout-btn:hover i {
            animation: spin 0.6s ease-in-out;
        }

        @keyframes spin {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <div class="card-content">
                <!-- Kolom Kiri: User Info -->
                <div class="left-panel">
                    <div class="left-content">
                        <div class="header-icon">
                            <i class="fas fa-user-shield"></i>
                        </div>
                        <h1 class="user-name">Harris Pop</h1>
                        <p class="user-role">Admin Request Status</p>
                    </div>
                </div>

                <!-- Kolom Kanan: Status & Aksi -->
                <div class="right-panel">
                    <div class="status-box">
                        <div class="status-title">
                            <i class="fas fa-info-circle"></i>
                            <span>Status Akun Admin Anda</span>
                        </div>
                        <div class="status-text">PENDING</div>
                        <p class="status-description">
                            Mohon tunggu persetujuan dari admin sistem.
                        </p>
                    </div>

                    <form method="POST" action="{{ route('logout') }}">
                        @csrf
                        <button type="submit" class="logout-btn">
                            <i class="fas fa-sign-out-alt"></i>
                            <span>Logout</span>
                        </button>
                    </form>

                    <div class="footer">
                        <p>© {{ date('Y') }} Harris Pop. All rights reserved.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const logoutBtn = document.querySelector('.logout-btn');

            if (window.matchMedia("(min-width: 768px)").matches) {
                logoutBtn.addEventListener('mouseover', function() {
                    this.querySelector('span').textContent = 'Keluar Sekarang';
                });
                logoutBtn.addEventListener('mouseout', function() {
                    this.querySelector('span').textContent = 'Logout';
                });
            }

            logoutBtn.addEventListener('click', function(e) {
                setTimeout(() => {
                    createParticles(e.clientX, e.clientY);
                }, 50);
            });

            function createParticles(x, y) {
                const colors = ['#ef4444', '#f87171', '#fecaca'];
                const container = document.body;

                for (let i = 0; i < 15; i++) {
                    const particle = document.createElement('div');
                    particle.style.cssText = `
                        position: fixed;
                        width: 5px; height: 5px;
                        border-radius: 50%;
                        background: ${colors[Math.floor(Math.random() * colors.length)]};
                        left: ${x}px; top: ${y}px;
                        pointer-events: none;
                        z-index: 9999;
                    `;

                    container.appendChild(particle);

                    const angle = Math.random() * Math.PI * 2;
                    const dist = 30 + Math.random() * 50;
                    const dur = 0.5 + Math.random() * 0.5;

                    particle.animate([
                        { transform: 'translate(0,0) scale(1)', opacity: 1 },
                        { transform: `translate(${Math.cos(angle)*dist}px, ${Math.sin(angle)*dist}px) scale(0)`, opacity: 0 }
                    ], {
                        duration: dur * 1000,
                        easing: 'cubic-bezier(0,0.9,0.57,1)',
                        fill: 'forwards'
                    });

                    setTimeout(() => particle.remove(), dur * 1000);
                }
            }
        });
    </script>
</body>
</html>
