@extends('layouts.AdminLayout')

@section('content')
    <h1 class="dashboard-title">
        {{ $checklist->hotel ? $checklist->hotel . ' — ' : '' }}{{ $checklist->title ?? 'Sections' }}
    </h1>
    <div class="section-scroll-wrapper">
        <div class="section-list">
            @forelse($sections as $section)
                <div class="section-accordion-item">
                    <!-- Header -->
                    <div
                        class="section-header d-flex justify-content-between align-items-center p-3 bg-white border rounded-top checklist-item-hover">
                        <div class="d-flex align-items-center gap-2 flex-grow-1 section-info">
                            <span class="section-title fw-bold text-dark">
                                {{ $section->title }}
                            </span>
                        </div>
                        <div class="d-flex align-items-center gap-2 section-actions">
                            <div class="dropdown">
                                <button class="icon-only-btn" type="button" data-bs-toggle="dropdown"
                                    data-bs-popper="static"
                                    aria-expanded="false" aria-label="Opsi section">
                                    <i class="fas fa-ellipsis-v text-muted"></i>
                                </button>
                                <ul class="dropdown-menu dropdown-menu-end">
                                    <li>
                                        <button class="dropdown-item text-primary d-flex align-items-center"
                                            data-bs-toggle="modal" data-bs-target="#editsection{{ $section->id }}">
                                            <i class="fas fa-edit me-2"></i> Edit Judul
                                        </button>
                                    </li>
                                    <li>
                                        <button class="dropdown-item text-danger d-flex align-items-center"
                                            data-bs-toggle="modal" data-bs-target="#hapussection{{ $section->id }}">
                                            <i class="fas fa-trash-alt me-2"></i> Hapus Halaman
                                        </button>
                                    </li>
                                </ul>
                            </div>
                            <button type="button" class="btn btn-sm btn-outline-secondary toggle-btn"
                                data-bs-toggle="collapse" data-bs-target="#sectionContent{{ $section->id }}"
                                aria-expanded="false" aria-controls="sectionContent{{ $section->id }}">
                                <i class="fas fa-chevron-down"></i>
                            </button>
                        </div>
                    </div>
                    <!-- Collapsible Content -->
                    <div id="sectionContent{{ $section->id }}" class="collapse">
                        <div class="p-3 border-start border-end border-bottom bg-white">
                            @if (isset($section->questions) && $section->questions->count() > 0)
                                <div class="question-list mb-3">
                                    @foreach ($section->questions as $index => $question)
                                        <div
                                            class="question-item d-flex justify-content-between align-items-start p-3 bg-white border rounded mb-2">
                                            <div class="flex-grow-1">
                                                <div class="question-text">
                                                     {{ $question->question_text }}
                                                </div>
                                                <div class="question-type text-muted mt-1">
                                                    Tipe: {{ $question->type ?? 'subQuestionList' }}
                                                </div>
                                            </div>
                                            <div class="d-flex align-items-center gap-2">
                                                 <button type="button" class="btn btn-sm btn-outline-warning"
                                                        data-bs-toggle="modal"
                                                        data-bs-target="#editQuestionModal{{ $question->id }}">
                                                        <i class="fas fa-edit"></i>
                                                    </button>
                                                <button type="button" class="icon-only-btn text-danger"
                                                    data-bs-toggle="modal"
                                                    data-bs-target="#hapusPertanyaanModal{{ $question->id }}"
                                                    aria-label="Hapus pertanyaan">
                                                    <i class="fas fa-trash-alt"></i>
                                                </button>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @else
                                <p class="text-muted text-center py-3 mb-0">
                                    Belum ada pertanyaan
                                </p>
                            @endif

                            <button class="btn btn-outline-primary btn-sm w-100 mt-2" data-bs-toggle="modal"
                                data-bs-target="#addQuestionModal{{ $section->id }}">
                                <i class="fas fa-plus me-2"></i>Tambah Pertanyaan
                            </button>
                        </div>
                    </div>
                </div>
            @empty
                <div class="empty-state">
                    <i class="fas fa-check-circle text-success"></i>
                    <h3>Tidak Ada Section</h3>
                    <p>Belum ada section untuk checklist ini.</p>
                </div>
            @endforelse
        </div>
    </div>
@endsection

@section('mobile-content')
    <div class="mobile-overlay">
        <div class="mobile-topbar">
            <div class="topbar-content">
                <a href="{{ route('admin.manajemen.checklist') }}" class="back-btn">
                    <i class="fas fa-arrow-left"></i>
                </a>
                <h4 class="topbar-title">
                    {{ $checklist->hotel ? $checklist->hotel . ' — ' . $checklist->title : $checklist->title }}
                </h4>
            </div>
        </div>
        <div class="mobile-main-content">
            <div class="section-list">
                @forelse($sections as $section)
                    <div class="section-accordion-item">
                        <div
                            class="section-header d-flex justify-content-between align-items-center p-3 bg-white border rounded-top checklist-item-hover">
                            <div class="d-flex align-items-center gap-2 flex-grow-1 section-info">
                                <span class="section-title fw-bold text-dark">
                                    {{ $section->title }}
                                </span>
                            </div>
                            <div class="d-flex align-items-center gap-2 section-actions">
                                <div class="dropdown">
                                    <button class="icon-only-btn" type="button" data-bs-toggle="dropdown"
                                        data-bs-popper="static"
                                        aria-expanded="false" aria-label="Opsi section">
                                        <i class="fas fa-ellipsis-v text-muted"></i>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-end">
                                        <li>
                                            <button class="dropdown-item text-primary d-flex align-items-center"
                                                data-bs-toggle="modal"
                                                data-bs-target="#editsection{{ $section->id }}">
                                                <i class="fas fa-edit me-2"></i> Edit Judul
                                            </button>
                                        </li>
                                        <li>
                                            <button class="dropdown-item text-danger d-flex align-items-center"
                                                data-bs-toggle="modal"
                                                data-bs-target="#hapussection{{ $section->id }}">
                                                <i class="fas fa-trash-alt me-2"></i> Hapus Halaman
                                            </button>
                                        </li>
                                    </ul>
                                </div>
                                <button type="button" class="btn btn-sm btn-outline-secondary toggle-btn"
                                    data-bs-toggle="collapse" data-bs-target="#sectionContentMobile{{ $section->id }}"
                                    aria-expanded="false" aria-controls="sectionContentMobile{{ $section->id }}">
                                    <i class="fas fa-chevron-down"></i>
                                </button>
                            </div>
                        </div>
                        <div id="sectionContentMobile{{ $section->id }}" class="collapse">
                            <div class="p-3 border-start border-end border-bottom bg-white">
                                @if (isset($section->questions) && $section->questions->count() > 0)
                                    <div class="question-list mb-3">
                                        @foreach ($section->questions as $index => $question)
                                            <div
                                                class="question-item d-flex justify-content-between align-items-start p-3 bg-white border rounded mb-2">
                                                <div class="flex-grow-1">
                                                    <div class="question-text">

                                                        {{ $question->question_text }}
                                                    </div>
                                                    <div class="question-type text-muted mt-1">
                                                        Tipe: {{ $question->type ?? 'subQuestionList' }}
                                                    </div>
                                                </div>
                                                <div class="d-flex align-items-center gap-2">
                                                    <button type="button" class="btn btn-sm btn-outline-warning"
                                                        data-bs-toggle="modal"
                                                        data-bs-target="#editQuestionModal{{ $question->id }}">
                                                        <i class="fas fa-edit"></i>
                                                    </button>
                                                    <button type="button" class="icon-only-btn text-danger"
                                                        data-bs-toggle="modal"
                                                        data-bs-target="#hapusPertanyaanModal{{ $question->id }}"
                                                        aria-label="Hapus pertanyaan">
                                                        <i class="fas fa-trash-alt"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                @else
                                    <p class="text-muted text-center py-3 mb-0">
                                        Belum ada pertanyaan
                                    </p>
                                @endif

                                <button class="btn btn-outline-primary btn-sm w-100 mt-2" data-bs-toggle="modal"
                                    data-bs-target="#addQuestionModal{{ $section->id }}">
                                    <i class="fas fa-plus me-2"></i>Tambah Pertanyaan
                                </button>
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="empty-state">
                        <i class="fas fa-check-circle text-success"></i>
                        <h3>Tidak Ada Section</h3>
                        <p>Belum ada section untuk checklist ini.</p>
                    </div>
                @endforelse
            </div>
        </div>
        <button class="mobile-fab" data-bs-toggle="modal" data-bs-target="#createsectionModal"
            aria-label="Tambah section baru">
            <i class="fas fa-plus"></i>
        </button>
    </div>
@endsection

<div class="universal-fab-container">
    <button class="universal-fab" data-bs-toggle="modal" data-bs-target="#createsectionModal"
        aria-label="Tambah section baru">
        <i class="fas fa-plus"></i>
    </button>
</div>

@push('modals')
    @include('admin.manajemen.modal.section_add')
    @include('admin.manajemen.modal.section_add')

@foreach ($sections as $section)

    @include('admin.manajemen.modal.section_edit', ['section' => $section])
    @include('admin.manajemen.modal.section_delete', ['section' => $section])

    @foreach ($section->questions as $question)

        @include('admin.manajemen.modal.question_add', ['section' => $section])

        @include('admin.manajemen.modal.question_edit', [
            'section' => $section,
            'question' => $question
        ])

    @endforeach


        <!-- Modal Hapus Pertanyaan -->
        @foreach ($section->questions as $question)
            <div class="modal fade" id="hapusPertanyaanModal{{ $question->id }}" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Hapus Pertanyaan</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <p>Anda yakin ingin menghapus pertanyaan:</p>
                            <p><strong>{{ $question->question_text }}</strong></p>
                            <p class="text-danger">Ini tidak dapat dibatalkan.</p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                            <form action="{{ route('admin.question.destroy', $question->id) }}" method="POST">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger">Hapus</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    @endforeach
@endpush

@push('styles')
    <style>
        /* 🔁 Ambil gaya checklist-item untuk konsistensi */
        .section-accordion-item {
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            /* overflow: hidden; ← DIHAPUS! */
            margin-bottom: 16px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.03);
            position: relative;
            /* JANGAN beri z-index di sini! */
        }

        .section-header {
            cursor: pointer;
            transition: background-color 0.2s ease;
            position: static; /* memastikan dropdown tidak terjebak */
        }

        .section-header:hover,
        .checklist-item-hover:hover {
            background-color: #f8fafc;
        }

        .section-title {
            font-size: 0.95rem;
            line-height: 1.4;
            white-space: normal;
            word-break: break-word;
            overflow-wrap: break-word;
            display: block;
        }

        .toggle-btn {
            width: 36px;
            height: 36px;
            padding: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            transition: transform 0.2s ease;
        }

        .toggle-btn i {
            font-size: 0.9rem;
        }

        .toggle-btn[aria-expanded="true"] i {
            transform: rotate(180deg);
        }

        /* Question Item Styling */
        .question-item {
            background: #f8fafc;
            border: 1px solid #e2e8f0;
            transition: all 0.2s ease;
            display: flex;
            flex-direction: row;
            align-items: flex-start;
            justify-content: space-between;
        }

        .question-item:hover {
            background: #f1f5f9;
            border-color: #cbd5e1;
        }

        .question-text {
            font-size: 0.95rem;
            line-height: 1.4;
            color: #1e293b;
            word-break: break-word;
            overflow-wrap: break-word;
            white-space: normal;
            max-width: calc(100% - 80px);
        }

        .question-type {
            font-size: 0.85rem;
        }

        .icon-only-btn.text-danger {
            color: #ef4444;
        }

        .icon-only-btn.text-danger:hover {
            color: #b91c1c;
            background: #fee2e2;
        }

        /* 🔁 Mobile layout dari checklist.blade.php */
        .mobile-main-content {
            flex: 1;
            padding: 96px 16px 120px;
            overflow-y: auto;
            background: #f8fafc;
            -webkit-overflow-scrolling: touch;
            scrollbar-width: thin;
            scrollbar-color: #cbd5e1 transparent;
        }

        .mobile-main-content::-webkit-scrollbar {
            width: 6px;
        }

        .mobile-main-content::-webkit-scrollbar-track {
            background: transparent;
        }

        .mobile-main-content::-webkit-scrollbar-thumb {
            background: #cbd5e1;
            border-radius: 3px;
        }

        .mobile-main-content::-webkit-scrollbar-thumb:hover {
            background: #94a3b8;
        }

        .mobile-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: #f8fafc;
            z-index: 9999;
            display: flex;
            flex-direction: column;
            overflow: hidden;
        }

        .mobile-topbar {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            background: linear-gradient(135deg, #0f172a, #1e293b);
            padding: 16px 20px;
            z-index: 1100;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            min-height: 60px;
            display: flex;
            align-items: center;
        }

        .topbar-content {
            display: flex;
            align-items: center;
            gap: 16px;
        }

        .back-btn {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.1);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            text-decoration: none;
            flex-shrink: 0;
        }

        .topbar-title {
            color: white;
            font-size: 1.1rem;
            font-weight: 600;
            margin: 0;
            flex: 1;
            text-align: center;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: normal;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            max-height: 2.8em;
            line-height: 1.4;
            padding: 0 8px;
        }

        .mobile-fab {
            position: fixed;
            bottom: 24px;
            right: 24px;
            width: 56px;
            height: 56px;
            border-radius: 50%;
            background: #3b82f6;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            text-decoration: none;
            box-shadow: 0 4px 12px rgba(59, 130, 246, 0.4);
            z-index: 1200;
            transition: all 0.25s ease;
            border: none;
            cursor: pointer;
        }

        .mobile-fab:hover {
            background: #2563eb;
            transform: scale(1.08);
        }

        .mobile-fab:active {
            transform: scale(0.98);
        }

        .mobile-fab i {
            font-size: 1.6rem;
        }

        .empty-state {
            text-align: center;
            padding: 2.5rem 1.5rem;
            color: #64748b;
        }

        .empty-state i {
            font-size: 2.5rem;
            margin-bottom: 1rem;
            color: #10b981;
        }

        .empty-state h3 {
            font-size: 1.25rem;
            font-weight: 600;
            color: #0f172a;
            margin: 0 0 0.5rem;
        }

        .empty-state p {
            margin: 0;
            font-size: 0.95rem;
        }

        .dropdown-menu {
            min-width: 150px;
            border-radius: 10px;
            box-shadow: 0 6px 16px rgba(0, 0, 0, 0.12);
            border: 1px solid #e2e8f0;
            padding: 6px 0;
            font-size: 0.95rem;
            margin: 0;
            z-index: 1070 !important; /* ⬅️ PENTING! */
        }

        .dropdown-item {
            padding: 10px 16px;
            color: #475569;
            font-size: 0.95rem;
        }

        .dropdown-item:hover {
            background: #f8fafc;
        }

        .dropdown-item.text-primary {
            color: #3b82f6;
        }

        .dropdown-item.text-primary:hover {
            background: #dbeafe;
            color: #1d4ed8;
        }

        .dropdown-item.text-danger {
            color: #ef4444;
        }

        .dropdown-item.text-danger:hover {
            background: #fee2e2;
            color: #b91c1c;
        }

        .icon-only-btn {
            background: none;
            border: none;
            padding: 8px;
            margin: -8px;
            cursor: pointer;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2rem;
            color: #64748b;
            transition: all 0.2s;
        }

        .icon-only-btn:hover {
            background: #f1f5f9;
            color: #334155;
            transform: scale(1.1);
        }

        .modal {
            z-index: 10050 !important;
        }

        .modal-backdrop {
            z-index: 10040 !important;
        }

        input,
        select,
        textarea {
            font-size: 16px;
        }

        /* Desktop */
        @media (min-width: 1024px) {
            .mobile-overlay {
                display: none !important;
            }

            .dashboard-title {
                font-size: 1.7rem;
                font-weight: 700;
                color: #0f172a;
                margin-bottom: 20px;
            }

            .section-accordion-item {
                border-radius: 14px;
            }

            .section-title {
                font-size: 1.1rem;
            }

            .toggle-btn {
                width: 40px;
                height: 40px;
            }

            .empty-state {
                text-align: center;
                padding: 3rem 2rem;
                max-width: 500px;
                margin: 2rem auto;
                background: white;
                border-radius: 16px;
                box-shadow: 0 4px 12px rgba(0, 0, 0, 0.03);
            }

            .empty-state i {
                font-size: 3rem;
                margin-bottom: 1.2rem;
                color: #10b981;
            }

            .empty-state h3 {
                font-size: 1.4rem;
            }

            .universal-fab-container {
                position: fixed;
                bottom: 24px;
                right: 24px;
                z-index: 1200;
                opacity: 0;
                transform: translateY(20px);
                transition: opacity 0.3s ease, transform 0.3s ease;
                pointer-events: none;
            }

            .universal-fab-container.visible {
                opacity: 1;
                transform: translateY(0);
            }

            .universal-fab {
                pointer-events: auto;
                width: 60px;
                height: 60px;
                border-radius: 50%;
                background: #3b82f6;
                display: flex;
                align-items: center;
                justify-content: center;
                color: white;
                box-shadow: 0 6px 16px rgba(59, 130, 246, 0.35);
                border: none;
                cursor: pointer;
                transition: all 0.25s ease;
                font-size: 1.7rem;
            }

            .universal-fab:hover {
                background: #2563eb;
                transform: scale(1.1);
            }
        }

        /* Mobile adjustments */
        @media (max-width: 1023px) {
            .universal-fab-container {
                display: none;
            }

            .section-title {
                font-size: 0.85rem;
                line-height: 1.3;
            }

            .toggle-btn {
                width: 32px;
                height: 32px;
            }

            .question-item {
                flex-direction: column;
                align-items: flex-start;
                gap: 8px;
                padding: 12px;
            }

            .question-text {
                font-size: 0.85rem;
                white-space: normal;
                word-break: break-word;
                overflow-wrap: break-word;
                max-width: 100%;
                width: 100%;
            }

            .question-type {
                font-size: 0.75rem;
            }

            .question-item .d-flex.align-items-center.gap-2 {
                width: 100%;
                justify-content: flex-end;
                margin-top: 4px;
            }
        }
    </style>
@endpush

@push('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize all modals
            document.querySelectorAll('.modal').forEach(el => {
                if (!bootstrap.Modal.getInstance(el)) {
                    new bootstrap.Modal(el);
                }
            });

            // Auto-focus first input
            document.querySelectorAll('.modal').forEach(modal => {
                modal.addEventListener('shown.bs.modal', function() {
                    const firstInput = this.querySelector('input[type="text"], select');
                    if (firstInput) setTimeout(() => firstInput.focus(), 300);
                });
            });

            // Form loading state
            document.querySelectorAll('form').forEach(form => {
                form.addEventListener('submit', function(e) {
                    const submitBtn = this.querySelector('button[type="submit"]');
                    if (submitBtn && !submitBtn.disabled) {
                        submitBtn.disabled = true;
                        const original = submitBtn.innerHTML;
                        submitBtn.innerHTML =
                            `<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Memproses...`;
                        setTimeout(() => {
                            if (submitBtn.disabled) {
                                submitBtn.disabled = false;
                                submitBtn.innerHTML = original;
                            }
                        }, 3000);
                    }
                });
            });

            // FAB scroll behavior (desktop)
            const fabContainer = document.querySelector('.universal-fab-container');
            if (fabContainer && window.innerWidth >= 1024) {
                let lastScroll = 0;
                const handleScroll = () => {
                    const currentScroll = window.scrollY;
                    if (currentScroll > 100 && currentScroll > lastScroll) {
                        fabContainer.classList.remove('visible');
                    } else {
                        fabContainer.classList.add('visible');
                    }
                    lastScroll = currentScroll;
                };
                window.addEventListener('scroll', handleScroll);
                setTimeout(() => fabContainer.classList.add('visible'), 300);
            }

            // Close modals on success
            @if (session('success'))
                document.querySelectorAll('.modal.show').forEach(el => {
                    const modal = bootstrap.Modal.getInstance(el);
                    if (modal) modal.hide();
                });
            @endif

            // Toggle accordion on header click (kecuali dropdown/toggle button)
            document.querySelectorAll('.section-header').forEach(header => {
                header.addEventListener('click', function(e) {
                    if (e.target.closest('.btn') || e.target.closest('.dropdown')) return;
                    const toggleBtn = this.querySelector('.toggle-btn');
                    if (toggleBtn) toggleBtn.click();
                });
            });
        });
    </script>
@endpush
