<!-- Modal Edit Section -->
<div class="modal fade" id="editsection{{ $section->id }}" tabindex="-1"
     aria-labelledby="editsectionLabel{{ $section->id }}" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content border-0 rounded-3 shadow">
            <div class="modal-header py-3 px-4">
                <h6 class="modal-title fw-semibold" id="editsectionLabel{{ $section->id }}">
                    Edit Section: {{ $section->title }}
                </h6>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body pt-0 px-4 pb-4">
                <form action="{{ route('section.edit', $section->id) }}" method="POST">
                    @csrf
                    @method('PUT')

                    <div class="mb-3">
                        <label for="title_{{ $section->id }}" class="form-label small text-muted">Judul Section</label>
                        <input type="text" id="title_{{ $section->id }}" name="title"
                               class="form-control form-control-lg"
                               value="{{ old('title', $section->title) }}"
                               required
                               autocomplete="off"
                               placeholder="Contoh: Kamar Mandi"
                               style="font-size: 16px;">
                        <div class="form-text">
                            Section ini berada di:
                            <strong>{{ $checklist->hotel ? $checklist->hotel . ' — ' : '' }}{{ $checklist->title }}</strong>
                        </div>
                    </div>

                    <div class="d-grid gap-2 mt-3">
                        <button type="submit" class="btn btn-warning btn-lg rounded-pill py-3">
                            <i class="fas fa-save me-2"></i>Simpan Perubahan
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
