<!-- ================= MODAL TAMBAH PERTANYAAN ================= -->
<div class="modal fade" id="addQuestionModal{{ $section->id }}" tabindex="-1"
    aria-labelledby="addQuestionModalLabel{{ $section->id }}" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content border-0 rounded-3 shadow">

            <!-- Header -->
            <div class="modal-header py-3 px-4 bg-light">
                <h6 class="modal-title fw-semibold text-dark" id="addQuestionModalLabel{{ $section->id }}">
                    <i class="fas fa-question-circle me-2 text-primary"></i>
                    Tambah Pertanyaan
                </h6>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <!-- Body -->
            <div class="modal-body pt-0 px-4 pb-4">
                <form action="{{ route('admin.manajemen.question.store') }}" method="POST">
                    @csrf

                    <input type="hidden" name="checklist_section_id" value="{{ $section->id }}">

                    <!-- Info Section -->
                    <div class="alert alert-light border rounded mb-4 p-3 bg-primary-subtle border-primary-subtle">
                        <small class="text-muted">Menambah ke section:</small>
                        <div class="fw-bold text-primary">{{ $section->title }}</div>
                    </div>

                    <!-- Tipe (tanpa opsi "-- Pilih Tipe --", langsung Yes/No terpilih) -->
                    <div class="mb-3">
                        <label class="form-label small fw-medium text-secondary">Tipe Pertanyaan *</label>
                        <select class="form-select border-primary-subtle" name="type" id="type_{{ $section->id }}"
                            onchange="renderDynamicOptions({{ $section->id }})">
                            <!-- ❌ Dihapus: <option value="">-- Pilih Tipe --</option> -->
                            <option value="yesNo" selected>Yes / No</option>
                            <option value="header">Header</option>
                            <option value="readOnlyText">Read Only Text</option>
                            <option value="subQuestionList">Sub Question List</option>
                            <option value="pageNote">Page Note</option>
                            <option value="imageUpload">Image Upload</option>
                        </select>
                    </div>

                    <!-- Judul Utama Pertanyaan -->
                    <div class="mb-3" id="questionTextContainer_{{ $section->id }}">
                        <label class="form-label small fw-medium text-secondary">Teks Pertanyaan *</label>
                        <textarea class="form-control border-primary-subtle" name="question_text" id="questionText_{{ $section->id }}"
                            rows="3" placeholder="Masukkan pertanyaan..."></textarea>
                    </div>

                    <!-- Dynamic Options Area -->
                    <div id="dynamicOptions_{{ $section->id }}" class="mt-3"></div>

                    <hr class="my-4">

                    <div class="d-grid gap-2">
                        <button type="submit" class="btn bg-primary py-2 text-white">
                            <i class="fas fa-save me-1"></i> Simpan Pertanyaan
                        </button>
                        <button type="button" class="btn btn-outline-secondary py-2" data-bs-dismiss="modal">
                            <i class="fas fa-times me-1"></i> Batal
                        </button>
                    </div>

                </form>
            </div>
        </div>
    </div>
</div>

<!-- ================= JS ================= -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Setel tipe ke 'yesNo' secara default dan render kontennya
        const typeSelect = document.getElementById('type_{{ $section->id }}');
        if (typeSelect) {
            typeSelect.value = 'yesNo'; // pastikan terpilih
            renderDynamicOptions({{ $section->id }});
        }
    });

    function renderDynamicOptions(sectionId) {
        const typeSelect = document.getElementById('type_' + sectionId);
        const dynamic = document.getElementById('dynamicOptions_' + sectionId);
        const questionTextContainer = document.getElementById('questionTextContainer_' + sectionId);
        const questionText = document.getElementById('questionText_' + sectionId);
        const type = typeSelect.value;

        let html = '';
        // Jangan reset nilai teks, biarkan user tetap bisa edit
        // questionText.value = ''; // ❌ dihapus

        if (type === 'yesNo') {
            questionTextContainer.style.display = 'block';
            questionText.placeholder = 'Masukkan pertanyaan Yes/No...';

            html = `
            <div class="border border-primary-subtle p-3 rounded bg-primary-subtle">
                <p class="small fw-medium text-primary mb-3">
                    <i class="fas fa-toggle-on me-1"></i> Pengaturan untuk tipe Yes/Na:
                </p>

                <div class="form-check form-switch mb-3">
                    <input class="form-check-input" type="checkbox" name="is_required" value="1" checked>
                    <label class="form-check-label fw-medium text-dark">Wajib diisi</label>
                    <small class="text-muted d-block">Pertanyaan harus dijawab</small>
                </div>

                <div class="form-check form-switch mb-3">
                    <input class="form-check-input has-comment" data-section="${sectionId}" type="checkbox" name="has_comment" value="1">
                    <label class="form-check-label fw-medium text-dark">Memiliki Field Komentar</label>
                    <small class="text-muted d-block">Pengguna dapat menambahkan komentar</small>
                </div>

                <div class="form-check form-switch mb-3">
                    <input class="form-check-input comment-child" data-section="${sectionId}" type="checkbox" name="comment_required" value="1" disabled>
                    <label class="form-check-label fw-medium text-dark">Komentar Wajib Diisi</label>
                    <small class="text-muted d-block">Komentar harus diisi jika tersedia</small>
                </div>

                <div class="form-check form-switch">
                    <input class="form-check-input" type="checkbox" name="image_required_if_no" value="1">
                    <label class="form-check-label fw-medium text-dark">Wajib Upload Gambar jika Jawaban "No"</label>
                    <small class="text-muted d-block">Foto diperlukan jika jawaban No</small>
                </div>
            </div>
            `;
        } else if (type === 'header') {
            questionTextContainer.style.display = 'block';
            questionText.placeholder = 'Masukkan teks header...';
            questionText.rows = 2;

            html = `
            <div class="border border-primary-subtle p-3 rounded bg-primary-subtle">
                <p class="small fw-medium text-primary mb-3">
                    <i class="fas fa-heading me-1"></i> Tipe Header akan ditampilkan sebagai judul atau pembatas section.
                </p>
                <div class="form-check form-switch mb-2">
                    <input class="form-check-input" type="checkbox" name="is_required" value="0" checked disabled>
                    <label class="form-check-label fw-medium text-secondary">Non-interaktif</label>
                    <small class="text-muted d-block">Header tidak memerlukan jawaban</small>
                </div>
            </div>
            `;
        } else if (type === 'readOnlyText') {
            questionTextContainer.style.display = 'block';
            questionText.placeholder = 'Masukkan teks informasi...';

            html = `
            <div class="border border-primary-subtle p-3 rounded bg-primary-subtle">
                <p class="small fw-medium text-primary mb-3">
                    <i class="fas fa-align-left me-1"></i> Tipe Read Only Text akan menampilkan informasi statis tanpa input.
                </p>
                <div class="form-check form-switch mb-2">
                    <input class="form-check-input" type="checkbox" name="is_required" value="0" checked disabled>
                    <label class="form-check-label fw-medium text-secondary">Hanya baca</label>
                    <small class="text-muted d-block">Teks hanya untuk dibaca, tidak memerlukan jawaban</small>
                </div>
            </div>
            `;
        } else if (type === 'subQuestionList') {
            questionTextContainer.style.display = 'block';
            questionText.placeholder = 'Masukkan judul utama pertanyaan...';

            html = `
            <div class="border border-primary-subtle p-3 rounded bg-primary-subtle">
                <p class="small fw-medium text-primary mb-3">
                    <i class="fas fa-list me-1"></i> Sub Question List memungkinkan membuat daftar pertanyaan terkait.
                </p>

                <div class="mb-4">
                    <label class="form-label small fw-medium text-secondary mb-2">Daftar Sub Pertanyaan:</label>
                    <div id="subContainer_${sectionId}" class="mb-3">
                        <p class="text-muted text-center mb-0 py-3">
                            <i class="fas fa-inbox me-1"></i> Belum ada sub pertanyaan
                        </p>
                    </div>

                    <button type="button" class="btn btn-sm bg-primary w-100 text-white mb-4" onclick="addSubQuestion(${sectionId})">
                        <i class="fas fa-plus me-1"></i> Tambah Sub Pertanyaan
                    </button>
                </div>
            </div>
            `;
        } else if (type === 'pageNote') {
            questionTextContainer.style.display = 'block';
            questionText.placeholder = 'Masukkan catatan atau instruksi...';

            html = `
            <div class="border border-primary-subtle p-3 rounded bg-primary-subtle">
                <p class="small fw-medium text-primary mb-3">
                    <i class="fas fa-sticky-note me-1"></i> Tipe Page Note untuk menampilkan catatan atau instruksi di halaman.
                </p>
                <div class="form-check form-switch mb-2">
                    <input class="form-check-input" type="checkbox" name="is_required" value="0" checked disabled>
                    <label class="form-check-label fw-medium text-secondary">Catatan halaman</label>
                    <small class="text-muted d-block">Hanya untuk informasi, tidak memerlukan jawaban</small>
                </div>
            </div>
            `;
        } else if (type === 'imageUpload') {
            questionTextContainer.style.display = 'block';
            questionText.placeholder = 'Masukkan instruksi upload gambar...';
        }

        dynamic.innerHTML = html;
        setupCommentToggle(sectionId);
    }

    // --- Fungsi lainnya tetap sama (addSubQuestion, updateSubQuestionNumbers, dll) ---
    function addSubQuestion(sectionId) {
        const container = document.getElementById('subContainer_' + sectionId);
        const subItems = container.querySelectorAll('.sub-question-item');
        const index = subItems.length + 1;

        if (container.innerText.includes('Belum ada')) {
            container.innerHTML = '';
        }

        const html = `
        <div class="sub-question-item mb-4 p-3 border border-primary-subtle rounded bg-white">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h6 class="mb-0 text-primary">Sub Pertanyaan ${index}</h6>
                <button type="button" class="btn btn-outline-danger btn-sm" onclick="this.closest('.sub-question-item').remove(); updateSubQuestionNumbers(${sectionId})">
                    <i class="fas fa-times"></i> Hapus
                </button>
            </div>

            <div class="mb-3">
                <label class="form-label small fw-medium text-secondary">Label *</label>
                <input type="text"
                       class="form-control border-primary-subtle"
                       name="sub_questions[${index}][text]"
                       placeholder="Masukkan label sub pertanyaan..."
                       required>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-check form-switch mb-2">
                        <input class="form-check-input" type="checkbox" name="sub_questions[${index}][required]" value="1" checked>
                        <label class="form-check-label fw-medium text-dark">Wajib Diisi</label>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-check form-switch mb-2">
                        <input class="form-check-input" type="checkbox" name="sub_questions[${index}][image_required_if_no]" value="1">
                        <label class="form-check-label fw-medium text-dark">Wajib Gambar jika "No"</label>
                    </div>
                </div>
            </div>
        </div>
        `;

        container.insertAdjacentHTML('beforeend', html);
    }

    function updateSubQuestionNumbers(sectionId) {
        const container = document.getElementById('subContainer_' + sectionId);
        const subItems = container.querySelectorAll('.sub-question-item');

        if (subItems.length === 0) {
            container.innerHTML = `
                <p class="text-muted text-center mb-0 py-3">
                    <i class="fas fa-inbox me-1"></i> Belum ada sub pertanyaan
                </p>
            `;
            return;
        }

        subItems.forEach((item, index) => {
            const title = item.querySelector('h6');
            const inputName = item.querySelector('input[name^="sub_questions"]');
            const requiredCheckbox = item.querySelector('input[name$="[required]"]');
            const imageCheckbox = item.querySelector('input[name$="[image_required_if_no]"]');

            if (title) title.textContent = `Sub Pertanyaan ${index + 1}`;
            if (inputName) {
                inputName.name = inputName.name.replace(/sub_questions\[\d+\]/, `sub_questions[${index + 1}]`);
            }
            if (requiredCheckbox) {
                requiredCheckbox.name = requiredCheckbox.name.replace(/sub_questions\[\d+\]/, `sub_questions[${index + 1}]`);
            }
            if (imageCheckbox) {
                imageCheckbox.name = imageCheckbox.name.replace(/sub_questions\[\d+\]/, `sub_questions[${index + 1}]`);
            }
        });
    }

    function setupCommentToggle(sectionId) {
        const existingCheckbox = document.querySelector('.has-comment[data-section="' + sectionId + '"]');
        if (existingCheckbox) {
            existingCheckbox.removeEventListener('change', handleCommentToggle);
            existingCheckbox.addEventListener('change', handleCommentToggle);
        }
    }

    function handleCommentToggle(e) {
        if (e.target.classList.contains('has-comment')) {
            const sectionId = e.target.dataset.section;
            const childs = document.querySelectorAll('.comment-child[data-section="' + sectionId + '"]');

            childs.forEach(ch => {
                ch.disabled = !e.target.checked;
                if (!e.target.checked) {
                    ch.checked = false;
                }
            });
        }
    }

    document.addEventListener('change', handleCommentToggle);
</script>
