<div class="modal fade" id="editChecklist{{ $checklist->id }}" tabindex="-1"
     aria-labelledby="editChecklistLabel{{ $checklist->id }}" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content border-0 rounded-3 shadow">
            <div class="modal-header py-3 px-4">
                <h6 class="modal-title fw-semibold" id="editChecklistLabel{{ $checklist->id }}">Edit Checklist</h6>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body pt-0 px-4 pb-4">
                <form action="{{ route('checklist.edit', $checklist->id) }}" method="POST">
                    @csrf
                    @method('PUT')

                    <div class="mb-3">
                        <label for="title_{{ $checklist->id }}" class="form-label small text-muted">Judul Checklist</label>
                        <input type="text" id="title_{{ $checklist->id }}" name="title"
                               class="form-control form-control-lg"
                               value="{{ old('title', $checklist->title) }}"
                               required
                               autocomplete="off"
                               style="font-size: 16px;">
                    </div>

                    <div class="mb-3">
                        <label for="hotel_{{ $checklist->id }}" class="form-label small text-muted">Hotel</label>
                        <select id="hotel_{{ $checklist->id }}" name="hotel" class="form-select form-select-lg" style="font-size: 16px;">
                            <option value="HARRIS" {{ $checklist->hotel == 'HARRIS' ? 'selected' : '' }}>HARRIS</option>
                            <option value="POP" {{ $checklist->hotel == 'POP' ? 'selected' : '' }}>POP</option>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="mod_type_{{ $checklist->id }}" class="form-label small text-muted">Kategori</label>
                        <select id="mod_type_{{ $checklist->id }}" name="mod_type" 
                                class="form-select form-select-lg" 
                                disabled 
                                style="font-size: 16px; background-color: #f8f9fa;">
                            <option value="general" {{ $checklist->mod_type == 'general' ? 'selected' : '' }}>General</option>
                            <option value="room_inspection" {{ $checklist->mod_type == 'room_inspection' ? 'selected' : '' }}>Room Inspection</option>
                        </select>
                        <input type="hidden" name="mod_type" value="{{ $checklist->mod_type }}">
                    </div>

                    <div class="d-grid gap-2 mt-3">
                        <button type="submit" class="btn btn-primary btn-lg rounded-pill py-3">
                            <i class="fas fa-save me-2"></i>Simpan Perubahan
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>