@extends('layouts.AdminLayout')
@section('title', 'Checklists')
@section('content')
<h1 class="dashboard-title">Checklists</h1>
<div class="checklist-scroll-wrapper">
    <div class="checklist-list">
        @forelse($checklists as $checklist)
        <div class="checklist-item">
            <!-- Area klik: checklist-info dibungkus <a> -->
            <a href="{{ route('admin.manajemen.section', $checklist->id) }}" class="checklist-card-link">
                <div class="checklist-info">
                    <div class="checklist-title">
                        {{ $checklist->hotel }} - {{ $checklist->title }}
                    </div>
                </div>
            </a>
            <!-- Dropdown tetap terpisah -->
            <div class="checklist-actions">
                <div class="dropdown">
                    <button class="icon-only-btn" type="button"
                        data-bs-toggle="dropdown"
                        aria-expanded="false"
                        aria-label="Opsi checklist">
                        <i class="fas fa-ellipsis-v text-muted"></i>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li>
                            <button class="dropdown-item text-primary d-flex align-items-center"
                                data-bs-toggle="modal"
                                data-bs-target="#editChecklist{{ $checklist->id }}">
                                <i class="fas fa-edit me-2"></i> Edit
                            </button>
                        </li>
                        <li>
                            <button class="dropdown-item text-danger d-flex align-items-center"
                                data-bs-toggle="modal"
                                data-bs-target="#hapusChecklist{{ $checklist->id }}">
                                <i class="fas fa-trash-alt me-2"></i> Hapus
                            </button>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        @empty
        <div class="empty-state">
            <i class="fas fa-check-circle text-success"></i>
            <h3>Tidak Ada Checklist</h3>
            <p>Belum ada checklist yang dibuat.</p>
        </div>
        @endforelse
    </div>
</div>
@endsection

@section('mobile-content')
<div class="mobile-overlay">
    <div class="mobile-topbar">
        <div class="topbar-content">
            <a href="{{ route('admin.manajemen') }}" class="back-btn">
                <i class="fas fa-arrow-left"></i>
            </a>
            <h2 class="topbar-title">Checklists</h2>
        </div>
    </div>
    <div class="mobile-main-content">
        <div class="checklist-list">
            @forelse($checklists as $checklist)
            <div class="checklist-item">
                <a href="{{ route('admin.manajemen.section', $checklist->id) }}" class="checklist-card-link">
                    <div class="checklist-info">
                        <div class="checklist-title">
                            {{ Str::limit($checklist->hotel . ' - ' . $checklist->title, 35) }}
                        </div>
                    </div>
                </a>
                <div class="checklist-actions">
                    <div class="dropdown">
                        <button class="icon-only-btn" type="button"
                            data-bs-toggle="dropdown"
                            aria-expanded="false"
                            aria-label="Opsi checklist">
                            <i class="fas fa-ellipsis-v text-muted"></i>
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li>
                                <button class="dropdown-item text-primary d-flex align-items-center"
                                    data-bs-toggle="modal"
                                    data-bs-target="#editChecklist{{ $checklist->id }}">
                                    <i class="fas fa-edit me-2"></i> Edit
                                </button>
                            </li>
                            <li>
                                <button class="dropdown-item text-danger d-flex align-items-center"
                                    data-bs-toggle="modal"
                                    data-bs-target="#hapusChecklist{{ $checklist->id }}">
                                    <i class="fas fa-trash-alt me-2"></i> Hapus
                                </button>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            @empty
            <div class="empty-state">
                <i class="fas fa-check-circle text-success"></i>
                <h3>Tidak Ada Checklist</h3>
                <p>Belum ada checklist yang dibuat.</p>
            </div>
            @endforelse
        </div>
    </div>
    <button class="mobile-fab"
        data-bs-toggle="modal"
        data-bs-target="#createChecklistModal"
        aria-label="Tambah checklist baru">
        <i class="fas fa-plus"></i>
    </button>
</div>
@endsection

<div class="universal-fab-container">
    <button class="universal-fab"
        data-bs-toggle="modal"
        data-bs-target="#createChecklistModal"
        aria-label="Tambah checklist baru">
        <i class="fas fa-plus"></i>
    </button>
</div>

@push('modals')
    @include('admin.manajemen.modal.checklist_add')
    @foreach($checklists as $checklist)
        @include('admin.manajemen.modal.checklist_edit', ['checklist' => $checklist])
        @include('admin.manajemen.modal.checklist_delete', ['checklist' => $checklist])
    @endforeach
@endpush

@push('styles')
<style>
/* ... (CSS tetap sama — tidak perlu diubah) ... */
.mobile-main-content {
    flex: 1;
    padding: 96px 16px 120px;
    overflow-y: auto;
    background: #f8fafc;
    -webkit-overflow-scrolling: touch;
    scrollbar-width: thin;
    scrollbar-color: #cbd5e1 transparent;
}
.mobile-main-content::-webkit-scrollbar {
    width: 6px;
}
.mobile-main-content::-webkit-scrollbar-track {
    background: transparent;
}
.mobile-main-content::-webkit-scrollbar-thumb {
    background: #cbd5e1;
    border-radius: 3px;
}
.mobile-main-content::-webkit-scrollbar-thumb:hover {
    background: #94a3b8;
}
.checklist-scroll-wrapper {
    max-height: calc(100vh - 180px);
    overflow-y: auto;
    padding-bottom: 20px;
    scrollbar-width: thin;
    scrollbar-color: #e2e8f0 transparent;
}
.checklist-scroll-wrapper::-webkit-scrollbar {
    width: 8px;
}
.checklist-scroll-wrapper::-webkit-scrollbar-track {
    background: transparent;
}
.checklist-scroll-wrapper::-webkit-scrollbar-thumb {
    background: #e2e8f0;
    border-radius: 4px;
}
.checklist-scroll-wrapper::-webkit-scrollbar-thumb:hover {
    background: #cbd5e1;
}
.mobile-overlay {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: #f8fafc;
    z-index: 9999;
    display: flex;
    flex-direction: column;
    overflow: hidden;
}
.mobile-topbar {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    background: linear-gradient(135deg, #0f172a, #1e293b);
    padding: 16px 20px;
    z-index: 1100;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
}
.topbar-content {
    display: flex;
    align-items: center;
    gap: 16px;
}
.back-btn {
    width: 36px;
    height: 36px;
    border-radius: 50%;
    background: rgba(255,255,255,0.1);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    text-decoration: none;
    flex-shrink: 0;
}
.topbar-title {
    color: white;
    font-size: 1.25rem;
    font-weight: 600;
    margin: 0;
    flex: 1;
    text-align: center;
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
}
.checklist-item {
    background: white;
    border: 1px solid #e2e8f0;
    border-radius: 12px;
    padding: 16px;
    margin-bottom: 16px;
    display: flex;
    align-items: center;
    justify-content: space-between;
    position: relative;
    box-shadow: 0 2px 4px rgba(0,0,0,0.03);
    transition: background-color 0.2s ease;
}
.checklist-card-link {
    text-decoration: none;
    color: inherit;
    flex: 1;
    min-width: 0;
    display: block;
    padding: 8px 0;
    margin: -8px 0 -8px -16px;
    padding-left: 16px;
}
.checklist-card-link:hover .checklist-title {
    color: #3b82f6;
}
.checklist-item:hover {
    background-color: #f8fafc;
    cursor: pointer;
}
.checklist-item.show .dropdown-menu {
    display: block;
}
.checklist-info {
    flex: 1;
    min-width: 0;
}
.checklist-title {
    font-weight: 600;
    color: #0f172a;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    font-size: 0.95rem;
    line-height: 1.4;
}
.checklist-actions {
    flex-shrink: 0;
    margin-left: 12px;
}
.mobile-fab {
    position: fixed;
    bottom: 24px;
    right: 24px;
    width: 56px;
    height: 56px;
    border-radius: 50%;
    background: #3b82f6;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    text-decoration: none;
    box-shadow: 0 4px 12px rgba(59, 130, 246, 0.4);
    z-index: 1200;
    transition: all 0.25s ease;
    border: none;
    cursor: pointer;
}
.mobile-fab:hover {
    background: #2563eb;
    transform: scale(1.08);
}
.mobile-fab:active {
    transform: scale(0.98);
}
.mobile-fab i {
    font-size: 1.6rem;
}
.empty-state {
    text-align: center;
    padding: 2.5rem 1.5rem;
    color: #64748b;
}
.empty-state i {
    font-size: 2.5rem;
    margin-bottom: 1rem;
    color: #10b981;
}
.empty-state h3 {
    font-size: 1.25rem;
    font-weight: 600;
    color: #0f172a;
    margin: 0 0 0.5rem;
}
.empty-state p {
    margin: 0;
    font-size: 0.95rem;
}
.dropdown-menu {
    min-width: 150px;
    border-radius: 10px;
    box-shadow: 0 6px 16px rgba(0,0,0,0.12);
    border: 1px solid #e2e8f0;
    padding: 6px 0;
    font-size: 0.95rem;
    margin: 0;
}
.dropdown-item {
    padding: 10px 16px;
    color: #475569;
    font-size: 0.95rem;
}
.dropdown-item:hover {
    background: #f8fafc;
}
.dropdown-item.text-primary {
    color: #3b82f6;
}
.dropdown-item.text-primary:hover {
    background: #dbeafe;
    color: #1d4ed8;
}
.dropdown-item.text-danger {
    color: #ef4444;
}
.dropdown-item.text-danger:hover {
    background: #fee2e2;
    color: #b91c1c;
}
.icon-only-btn {
    background: none;
    border: none;
    padding: 8px;
    margin: -8px;
    cursor: pointer;
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.2rem;
    color: #64748b;
    transition: all 0.2s;
    z-index: 2;
    position: relative;
}
.icon-only-btn:hover {
    background: #f1f5f9;
    color: #334155;
    transform: scale(1.1);
}
.modal {
    z-index: 10050 !important;
}
.modal-backdrop {
    z-index: 10040 !important;
}
input, select, textarea {
    font-size: 16px;
}
@media (min-width: 1024px) {
    .mobile-overlay {
        display: none !important;
    }
    .dashboard-title {
        font-size: 1.7rem;
        font-weight: 700;
        color: #0f172a;
        margin-bottom: 20px;
    }
    .checklist-item {
        background: white;
        border-radius: 14px;
        padding: 20px;
        box-shadow: 0 3px 8px rgba(0,0,0,0.03);
        display: flex;
        justify-content: space-between;
        align-items: center;
        border: 1px solid #f1f5f9;
    }
    .checklist-card-link {
        margin: -12px -20px -12px -20px;
        padding: 12px 20px 12px 20px;
    }
    .checklist-title {
        font-weight: 600;
        font-size: 1.1rem;
        color: #0f172a;
        white-space: normal;
        overflow: visible;
        text-overflow: unset;
    }
    .empty-state {
        text-align: center;
        padding: 3rem 2rem;
        max-width: 500px;
        margin: 2rem auto;
        background: white;
        border-radius: 16px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.03);
    }
    .empty-state i {
        font-size: 3rem;
        margin-bottom: 1.2rem;
        color: #10b981;
    }
    .empty-state h3 {
        font-size: 1.4rem;
        font-weight: 700;
        color: #0f172a;
    }
    .empty-state p {
        color: #64748b;
        font-size: 1rem;
    }
    .universal-fab-container {
        position: fixed;
        bottom: 24px;
        right: 24px;
        z-index: 1200;
        opacity: 0;
        transform: translateY(20px);
        transition: opacity 0.3s ease, transform 0.3s ease;
        pointer-events: none;
    }
    .universal-fab-container.visible {
        opacity: 1;
        transform: translateY(0);
    }
    .universal-fab {
        pointer-events: auto;
        width: 60px;
        height: 60px;
        border-radius: 50%;
        background: #3b82f6;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        box-shadow: 0 6px 16px rgba(59, 130, 246, 0.35);
        border: none;
        cursor: pointer;
        transition: all 0.25s ease;
        font-size: 1.7rem;
    }
    .universal-fab:hover {
        background: #2563eb;
        transform: scale(1.1);
    }
    .universal-fab:active {
        transform: scale(0.98);
    }
}
@media (max-width: 1023px) {
    .universal-fab-container {
        display: none;
    }
}
</style>
@endpush

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function () {
    // Inisialisasi semua modal
    document.querySelectorAll('.modal').forEach(el => {
        if (!bootstrap.Modal.getInstance(el)) {
            new bootstrap.Modal(el);
        }
    });

    // Auto-focus input pertama saat modal muncul
    document.querySelectorAll('.modal').forEach(modal => {
        modal.addEventListener('shown.bs.modal', function () {
            const firstInput = this.querySelector('input[type="text"], select');
            if (firstInput) setTimeout(() => firstInput.focus(), 300);
        });
    });

    // Loading button saat submit
    document.querySelectorAll('form').forEach(form => {
        form.addEventListener('submit', function(e) {
            const submitBtn = this.querySelector('button[type="submit"]');
            if (submitBtn && !submitBtn.disabled) {
                submitBtn.disabled = true;
                const original = submitBtn.innerHTML;
                submitBtn.innerHTML = `<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Memproses...`;
                setTimeout(() => {
                    if (submitBtn.disabled) {
                        submitBtn.disabled = false;
                        submitBtn.innerHTML = original;
                    }
                }, 3000);
            }
        });
    });

    // FAB scroll behavior (desktop)
    const fabContainer = document.querySelector('.universal-fab-container');
    if (fabContainer && window.innerWidth >= 1024) {
        let lastScroll = 0;
        const handleScroll = () => {
            const currentScroll = window.scrollY;
            if (currentScroll > 100 && currentScroll > lastScroll) {
                fabContainer.classList.remove('visible');
            } else {
                fabContainer.classList.add('visible');
            }
            lastScroll = currentScroll;
        };
        window.addEventListener('scroll', handleScroll);
        setTimeout(() => fabContainer.classList.add('visible'), 300);
    }

    // Close semua modal jika ada success message
    @if(session('success'))
    document.querySelectorAll('.modal.show').forEach(el => {
        const modal = bootstrap.Modal.getInstance(el);
        if (modal) modal.hide();
    });
    @endif

    // Smooth scroll untuk anchor internal
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function(e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });

    // Prevent redirect on dropdown click
    document.querySelectorAll('.checklist-item').forEach(item => {
        const dropdown = item.querySelector('.dropdown');
        if (!dropdown) return;
        item.addEventListener('click', function(e) {
            if (e.target.closest('.dropdown') || e.target.closest('.dropdown-menu')) {
                return;
            }
        });
    });
});
</script>
@endpush
