@extends('layouts.AdminLayout')

@push('styles')
<style>
    /* ===== VARIABEL ===== */
    :root {
        --primary: #3b82f6;
        --primary-dark: #2563eb;
        --primary-light: #60a5fa;
        --success: #10b981;
        --warning: #f59e0b;
        --danger: #ef4444;
        --info: #3b82f6;
        --gray-50: #f9fafb;
        --gray-100: #f3f4f6;
        --gray-200: #e5e7eb;
        --gray-300: #d1d5db;
        --gray-400: #9ca3af;
        --gray-500: #6b7280;
        --gray-600: #4b5563;
        --gray-700: #374151;
        --gray-800: #1f2937;
        --gray-900: #111827;
    }

    /* ===== TITLE ===== */
    .dashboard-title {
        font-size: 1.6rem;
        font-weight: 700;
        margin-bottom: 24px;
        color: var(--gray-900);
        letter-spacing: -0.5px;
        display: flex;
        align-items: center;
        justify-content: space-between;
        flex-wrap: wrap;
        gap: 12px;
    }

    .title-actions {
        display: flex;
        gap: 10px;
    }

    .btn-refresh {
        background: white;
        border: 1px solid var(--gray-200);
        border-radius: 12px;
        padding: 8px 16px;
        font-size: 0.9rem;
        font-weight: 500;
        color: var(--gray-700);
        display: flex;
        align-items: center;
        gap: 8px;
        transition: all 0.2s;
        cursor: pointer;
    }

    .btn-refresh:hover {
        background: var(--gray-50);
        border-color: var(--primary);
        color: var(--primary);
        transform: translateY(-2px);
        box-shadow: 0 4px 10px rgba(0,0,0,0.05);
    }

    /* ===== STATISTIK CARDS ===== */
    .stats-grid {
        display: grid;
        grid-template-columns: repeat(4, 1fr);
        gap: 20px;
        margin-bottom: 30px;
    }

    .stat-card {
        background: white;
        border-radius: 20px;
        padding: 20px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        border: 1px solid var(--gray-200);
        display: flex;
        align-items: center;
        gap: 16px;
        transition: transform 0.2s, box-shadow 0.2s;
    }

    .stat-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 12px 24px rgba(0, 0, 0, 0.1);
    }

    .stat-icon {
        width: 54px;
        height: 54px;
        border-radius: 16px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.8rem;
    }

    .stat-content h3 {
        font-size: 0.9rem;
        font-weight: 600;
        color: var(--gray-500);
        margin-bottom: 4px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .stat-number {
        font-size: 2rem;
        font-weight: 700;
        color: var(--gray-900);
        line-height: 1.2;
    }

    /* ===== PROGRESS SECTION ===== */
    .progress-section {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 20px;
        margin-bottom: 30px;
    }

    .progress-card {
        background: white;
        border-radius: 20px;
        padding: 20px;
        border: 1px solid var(--gray-200);
        box-shadow: 0 4px 12px rgba(0,0,0,0.05);
    }

    .progress-header {
        display: flex;
        align-items: center;
        gap: 12px;
        margin-bottom: 16px;
    }

    .progress-header h3 {
        font-size: 1.1rem;
        font-weight: 600;
        color: var(--gray-800);
    }

    .hotel-badge {
        padding: 4px 12px;
        border-radius: 30px;
        font-size: 0.8rem;
        font-weight: 600;
        background: var(--gray-100);
        color: var(--gray-700);
    }

    .progress-item {
        margin-bottom: 16px;
    }

    .progress-label {
        display: flex;
        justify-content: space-between;
        font-size: 0.9rem;
        color: var(--gray-600);
        margin-bottom: 6px;
    }

    .progress-bar-bg {
        height: 8px;
        background: var(--gray-200);
        border-radius: 20px;
        overflow: hidden;
    }

    .progress-bar-fill {
        height: 100%;
        border-radius: 20px;
        transition: width 0.3s ease;
    }

    .fill-general {
        background: linear-gradient(90deg, var(--primary), var(--primary-light));
    }

    .fill-room {
        background: linear-gradient(90deg, var(--warning), #fbbf24);
    }

    /* ===== DUAL SECTION (AKTIVITAS & JADWAL) ===== */
    .dual-section {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 20px;
        margin-bottom: 30px;
    }

    /* Aktivitas Terbaru */
    .recent-activity, .upcoming-schedule {
        background: white;
        border-radius: 20px;
        border: 1px solid var(--gray-200);
        overflow: hidden;
        box-shadow: 0 4px 12px rgba(0,0,0,0.05);
    }

    .activity-header, .schedule-header {
        padding: 18px 24px;
        background: var(--gray-50);
        border-bottom: 1px solid var(--gray-200);
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .activity-header h3, .schedule-header h3 {
        font-size: 1.1rem;
        font-weight: 600;
        color: var(--gray-800);
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .view-all-link {
        color: var(--primary);
        font-size: 0.9rem;
        font-weight: 500;
        text-decoration: none;
        display: flex;
        align-items: center;
        gap: 4px;
        transition: color 0.2s;
    }

    .view-all-link:hover {
        color: var(--primary-dark);
    }

    .activity-list, .schedule-list {
        padding: 0;
    }

    .activity-item, .schedule-item {
        display: flex;
        align-items: center;
        padding: 16px 24px;
        border-bottom: 1px solid var(--gray-100);
        transition: background 0.2s;
    }

    .activity-item:last-child, .schedule-item:last-child {
        border-bottom: none;
    }

    .activity-item:hover, .schedule-item:hover {
        background: var(--gray-50);
    }

    .activity-icon, .schedule-icon {
        width: 40px;
        height: 40px;
        border-radius: 12px;
        background: var(--gray-100);
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 16px;
        color: var(--gray-600);
        font-size: 1.1rem;
    }

    .activity-detail, .schedule-detail {
        flex: 1;
    }

    .activity-title, .schedule-title {
        font-weight: 600;
        color: var(--gray-800);
        margin-bottom: 4px;
    }

    .activity-meta, .schedule-meta {
        font-size: 0.85rem;
        color: var(--gray-500);
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .activity-time, .schedule-date {
        display: flex;
        align-items: center;
        gap: 4px;
    }

    .status-badge {
        display: inline-flex;
        align-items: center;
        padding: 4px 10px;
        border-radius: 30px;
        font-size: 0.75rem;
        font-weight: 600;
    }

    .status-badge.pending {
        background: #fff3cd;
        color: #856404;
    }

    .status-badge.completed {
        background: #d1fae5;
        color: #065f46;
    }

    .status-badge.submitted {
        background: #dbeafe;
        color: #1e40af;
    }

    /* ===== DESKTOP CARDS ===== */
    .desktop-cards {
        display: flex;
        flex-direction: column;
        gap: 20px;
        margin-top: 20px;
    }

    .desktop-card {
        background: white;
        border-radius: 18px;
        padding: 22px 24px;
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.05);
        display: flex;
        justify-content: space-between;
        align-items: center;
        transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
        text-decoration: none;
        position: relative;
        overflow: hidden;
    }

    .desktop-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 4px;
        height: 100%;
        background: linear-gradient(to bottom, var(--primary), var(--primary-light));
        opacity: 0;
        transition: opacity 0.3s;
    }

    .desktop-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.08);
        border-color: #dbeafe;
    }

    .desktop-card:hover::before {
        opacity: 1;
    }

    .card-content {
        display: flex;
        align-items: center;
        flex: 1;
    }

    .card-icon {
        width: 52px;
        height: 52px;
        border-radius: 16px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 20px;
        font-size: 1.4rem;
        background: rgba(59, 130, 246, 0.08);
        color: var(--primary);
        transition: all 0.25s;
    }

    .desktop-card:hover .card-icon {
        background: rgba(59, 130, 246, 0.15);
        transform: scale(1.05);
    }

    .card-text h3 {
        font-weight: 600;
        margin-bottom: 6px;
        font-size: 1.15rem;
        color: var(--gray-800);
        transition: color 0.2s;
    }

    .desktop-card:hover .card-text h3 {
        color: var(--primary);
    }

    .card-text p {
        font-size: 0.92rem;
        color: var(--gray-500);
        line-height: 1.5;
        max-width: 300px;
    }

    .card-arrow {
        color: var(--gray-300);
        font-size: 1.25rem;
        transition: transform 0.3s, color 0.2s;
    }

    .desktop-card:hover .card-arrow {
        color: var(--primary);
        transform: translateX(4px);
    }

    /* Badge notifikasi */
    .badge {
        position: absolute;
        top: -6px;
        right: -8px;
        background: var(--danger);
        color: white;
        font-size: 0.75rem;
        font-weight: 700;
        padding: 3px 8px;
        border-radius: 20px;
        min-width: 20px;
        text-align: center;
        box-shadow: 0 2px 6px rgba(239, 68, 68, 0.3);
        animation: pulse 2s infinite;
    }

    @keyframes pulse {
        0% { box-shadow: 0 0 0 0 rgba(239, 68, 68, 0.4); }
        70% { box-shadow: 0 0 0 8px rgba(239, 68, 68, 0); }
        100% { box-shadow: 0 0 0 0 rgba(239, 68, 68, 0); }
    }

    /* ===== MOBILE DASHBOARD ===== */
    @media (max-width: 1023px) {
        .stats-grid {
            grid-template-columns: repeat(2, 1fr);
            gap: 12px;
        }

        .stat-card {
            padding: 16px;
        }

        .stat-icon {
            width: 44px;
            height: 44px;
            font-size: 1.4rem;
        }

        .stat-number {
            font-size: 1.5rem;
        }

        .progress-section {
            grid-template-columns: 1fr;
            gap: 16px;
        }

        .dual-section {
            grid-template-columns: 1fr;
            gap: 16px;
        }

        .activity-header, .schedule-header {
            padding: 14px 18px;
        }

        .activity-item, .schedule-item {
            padding: 14px 18px;
        }

        .mobile-cards {
            display: flex;
            flex-direction: column;
            gap: 18px;
            margin-top: 20px;
        }

        .mobile-card {
            background: white;
            border-radius: 18px;
            padding: 20px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.06);
            display: flex;
            justify-content: space-between;
            align-items: center;
            transition: all 0.25s ease;
            text-decoration: none;
            position: relative;
        }

        .mobile-card:active {
            transform: scale(0.98);
            background: var(--gray-50);
        }

        .mobile-card-content {
            display: flex;
            align-items: center;
            flex: 1;
        }

        .mobile-card-icon {
            width: 48px;
            height: 48px;
            border-radius: 14px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 16px;
            font-size: 1.3rem;
            background: rgba(59, 130, 246, 0.08);
            color: var(--primary);
        }

        .mobile-card-text h3 {
            font-weight: 600;
            margin-bottom: 4px;
            font-size: 1.05rem;
            color: var(--gray-800);
        }

        .mobile-card-text p {
            font-size: 0.88rem;
            color: var(--gray-500);
            line-height: 1.45;
        }

        .mobile-card-arrow {
            color: var(--gray-300);
            font-size: 1.15rem;
        }

        .badge {
            top: -5px;
            right: -7px;
            font-size: 0.7rem;
            padding: 2px 7px;
            min-width: 18px;
        }
    }

    @media (max-width: 480px) {
        .stats-grid {
            grid-template-columns: 1fr;
        }
    }
</style>
@endpush

@section('content')
    <div class="dashboard-title">
        <span>Dashboard Admin</span>
        <div class="title-actions">
            <button class="btn-refresh" onclick="refreshDashboard()">
                <i class="fas fa-sync-alt"></i> Refresh
            </button>
        </div>
    </div>

    <!-- Statistik Cards -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon" style="background: #dbeafe; color: var(--primary);">
                <i class="fas fa-users"></i>
            </div>
            <div class="stat-content">
                <h3>Total User</h3>
                <div class="stat-number">{{ $totalUsers ?? 0 }}</div>
            </div>
        </div>
        <div class="stat-card">
            <div class="stat-icon" style="background: #e0f2fe; color: #0369a1;">
                <i class="fas fa-clipboard-list"></i>
            </div>
            <div class="stat-content">
                <h3>MOD Hari Ini</h3>
                <div class="stat-number">{{ $totalModToday ?? 0 }}</div>
            </div>
        </div>
        <div class="stat-card">
            <div class="stat-icon" style="background: #d1fae5; color: #065f46;">
                <i class="fas fa-check-circle"></i>
            </div>
            <div class="stat-content">
                <h3>Selesai</h3>
                <div class="stat-number">{{ $completedModToday ?? 0 }}</div>
            </div>
        </div>
        <div class="stat-card">
            <div class="stat-icon" style="background: #fff3cd; color: #856404;">
                <i class="fas fa-clock"></i>
            </div>
            <div class="stat-content">
                <h3>Pending</h3>
                <div class="stat-number">{{ $pendingModToday ?? 0 }}</div>
            </div>
        </div>
    </div>

    <!-- Menu Cepat -->
    <div class="desktop-cards">
        <a href="{{ route('admin.usermod') }}" class="desktop-card">
            <div class="card-content">
                <div class="card-icon">
                    <i class="fas fa-users"></i>
                </div>
                <div class="card-text">
                    <h3>Users</h3>
                    <p>Lihat status MOD semua user</p>
                </div>
            </div>
            <i class="fas fa-chevron-right card-arrow"></i>
        </a>

        <a href="{{ route('admin.adminrequest') }}" class="desktop-card">
            <div class="card-content">
                <div class="card-icon">
                    <i class="fas fa-user-plus"></i>
                </div>
                <div class="card-text">
                    <h3>Admin Requests</h3>
                    <p>Setujui atau tolak permintaan admin</p>
                </div>
            </div>
            <div style="position: relative; display: flex; align-items: center;">
                <i class="fas fa-bell" style="color: var(--gray-300); font-size: 1.25rem;"></i>
                @if(($pendingUsersCount ?? 0) > 0)
                    <span class="badge">{{ $pendingUsersCount }}</span>
                @endif
            </div>
        </a>
    </div>

    <!-- Aktivitas Terbaru & Jadwal Mendatang -->
    <div class="dual-section">
        <!-- Aktivitas Terbaru -->
        <div class="recent-activity">
            <div class="activity-header">
                <h3><i class="fas fa-history"></i> Aktivitas Terbaru</h3>
                <a href="{{ route('admin.adminrequest') }}" class="view-all-link">
                    Lihat Semua <i class="fas fa-arrow-right"></i>
                </a>
            </div>
            <div class="activity-list">
                @forelse($recentActivities ?? [] as $activity)
                <div class="activity-item">
                    <div class="activity-icon">
                        <i class="fas fa-{{ $activity['icon'] ?? 'user' }}"></i>
                    </div>
                    <div class="activity-detail">
                        <div class="activity-title">{{ $activity['title'] }}</div>
                        <div class="activity-meta">
                            <span class="activity-time"><i class="far fa-clock"></i> {{ $activity['time'] }}</span>
                            <span class="status-badge {{ $activity['status'] }}">{{ ucfirst($activity['status']) }}</span>
                        </div>
                    </div>
                </div>
                @empty
                <div class="activity-item" style="justify-content: center; color: var(--gray-500);">
                    <i class="fas fa-info-circle" style="margin-right: 8px;"></i> Belum ada aktivitas
                </div>
                @endforelse
            </div>
        </div>

        <!-- Jadwal Mendatang -->
        <div class="upcoming-schedule">
            <div class="schedule-header">
                <h3><i class="fas fa-calendar-alt"></i> Jadwal Mendatang</h3>
                <a href="{{ route('admin.jadwal') }}" class="view-all-link">
                    Lihat Semua <i class="fas fa-arrow-right"></i>
                </a>
            </div>
            <div class="schedule-list">
                @forelse($upcomingJadwal ?? [] as $jadwal)
                <div class="schedule-item">
                    <div class="schedule-icon">
                        <i class="fas fa-calendar-day"></i>
                    </div>
                    <div class="schedule-detail">
                        <div class="schedule-title">{{ $jadwal['name'] ?? 'Jadwal MOD' }}</div>
                        <div class="schedule-meta">
                            <span class="schedule-date"><i class="far fa-calendar"></i> {{ $jadwal['date'] }}</span>
                            <span class="schedule-date"><i class="far fa-clock"></i> {{ $jadwal['time'] ?? '08:00 - 17:00' }}</span>
                        </div>
                    </div>
                </div>
                @empty
                <div class="schedule-item" style="justify-content: center; color: var(--gray-500);">
                    <i class="fas fa-info-circle" style="margin-right: 8px;"></i> Tidak ada jadwal mendatang
                </div>
                @endforelse
            </div>
        </div>
    </div>

@endsection

@section('mobile-content')
    <div class="dashboard-title">
        <span>Dashboard Admin</span>
        <button class="btn-refresh" onclick="refreshDashboard()">
            <i class="fas fa-sync-alt"></i>
        </button>
    </div>

    <!-- Statistik Cards (Mobile) -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon" style="background: #dbeafe; color: var(--primary);">
                <i class="fas fa-users"></i>
            </div>
            <div class="stat-content">
                <h3>Total</h3>
                <div class="stat-number">{{ $totalUsers ?? 0 }}</div>
            </div>
        </div>
        <div class="stat-card">
            <div class="stat-icon" style="background: #e0f2fe; color: #0369a1;">
                <i class="fas fa-clipboard-list"></i>
            </div>
            <div class="stat-content">
                <h3>Hari Ini</h3>
                <div class="stat-number">{{ $totalModToday ?? 0 }}</div>
            </div>
        </div>
        <div class="stat-card">
            <div class="stat-icon" style="background: #d1fae5; color: #065f46;">
                <i class="fas fa-check-circle"></i>
            </div>
            <div class="stat-content">
                <h3>Selesai</h3>
                <div class="stat-number">{{ $completedModToday ?? 0 }}</div>
            </div>
        </div>
        <div class="stat-card">
            <div class="stat-icon" style="background: #fff3cd; color: #856404;">
                <i class="fas fa-clock"></i>
            </div>
            <div class="stat-content">
                <h3>Pending</h3>
                <div class="stat-number">{{ $pendingModToday ?? 0 }}</div>
            </div>
        </div>
    </div>

    <!-- Menu Cepat Mobile -->
    <div class="mobile-cards">
        <a href="{{ route('admin.usermod') }}" class="mobile-card">
            <div class="mobile-card-content">
                <div class="mobile-card-icon">
                    <i class="fas fa-users"></i>
                </div>
                <div class="mobile-card-text">
                    <h3>Users</h3>
                    <p>Status MOD semua user</p>
                </div>
            </div>
            <i class="fas fa-chevron-right mobile-card-arrow"></i>
        </a>

        <a href="{{ route('admin.adminrequest') }}" class="mobile-card">
            <div class="mobile-card-content">
                <div class="mobile-card-icon">
                    <i class="fas fa-user-plus"></i>
                </div>
                <div class="mobile-card-text">
                    <h3>Admin Requests</h3>
                    <p>Setujui / tolak permintaan</p>
                </div>
            </div>
            <div style="position: relative; display: flex; align-items: center;">
                <i class="fas fa-bell" style="color: var(--gray-300);"></i>
                @if(($pendingUsersCount ?? 0) > 0)
                    <span class="badge">{{ $pendingUsersCount }}</span>
                @endif
            </div>
        </a>
    </div>

    <!-- Aktivitas Terbaru (Mobile) -->
    <div class="recent-activity" style="margin-bottom: 16px;">
        <div class="activity-header">
            <h3><i class="fas fa-history"></i> Aktivitas</h3>
            <a href="{{ route('admin.adminrequest') }}" class="view-all-link">
                <i class="fas fa-arrow-right"></i>
            </a>
        </div>
        <div class="activity-list">
            @forelse($recentActivities ?? [] as $activity)
            <div class="activity-item">
                <div class="activity-icon">
                    <i class="fas fa-{{ $activity['icon'] ?? 'user' }}"></i>
                </div>
                <div class="activity-detail">
                    <div class="activity-title">{{ $activity['title'] }}</div>
                    <div class="activity-meta">
                        <span class="activity-time"><i class="far fa-clock"></i> {{ $activity['time'] }}</span>
                        <span class="status-badge {{ $activity['status'] }}">{{ ucfirst($activity['status']) }}</span>
                    </div>
                </div>
            </div>
            @empty
            <div class="activity-item" style="justify-content: center;">
                <i class="fas fa-info-circle"></i> Belum ada aktivitas
            </div>
            @endforelse
        </div>
    </div>

    <!-- Jadwal Mendatang (Mobile) -->
    <div class="upcoming-schedule" style="margin-bottom: 16px;">
        <div class="schedule-header">
            <h3><i class="fas fa-calendar-alt"></i> Jadwal</h3>
            <a href="{{ route('admin.jadwal') }}" class="view-all-link">
                <i class="fas fa-arrow-right"></i>
            </a>
        </div>
        <div class="schedule-list">
            @forelse($upcomingJadwal ?? [] as $jadwal)
            <div class="schedule-item">
                <div class="schedule-icon">
                    <i class="fas fa-calendar-day"></i>
                </div>
                <div class="schedule-detail">
                    <div class="schedule-title">{{ $jadwal['name'] ?? 'Jadwal MOD' }}</div>
                    <div class="schedule-meta">
                        <span class="schedule-date"><i class="far fa-calendar"></i> {{ $jadwal['date'] }}</span>
                    </div>
                </div>
            </div>
            @empty
            <div class="schedule-item" style="justify-content: center;">
                <i class="fas fa-info-circle"></i> Tidak ada jadwal
            </div>
            @endforelse
        </div>
    </div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    function refreshDashboard() {
        Swal.fire({
            icon: 'info',
            title: 'Memperbarui data...',
            timer: 1000,
            showConfirmButton: false,
            didOpen: () => {
                Swal.showLoading();
            }
        }).then(() => {
            window.location.reload();
        });
    }
</script>
@endpush