<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('questions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('checklist_section_id')->constrained()->cascadeOnDelete();
            $table->text('question_text');
            $table->enum('type',['yesNo','header','readOnlyText','subQuestionList','pageNote','imageUpload']);
            $table->boolean('is_required')->default(false);
            $table->boolean('has_comment')->default(false);
            $table->boolean('comment_required')->default(false);
            $table->boolean('image_required_if_no')->default(false);

            $table->integer('order')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('questions');
    }
};

