<?php

namespace App\Models;

use App\Models\SubQuestion;
use App\Models\ChecklistSubmission;
use Illuminate\Database\Eloquent\Model;

class SubQuestionAnswer extends Model
{
    protected $fillable = [
        'checklist_submission_id',
        'sub_question_id',
        'room_number',
        'answer_yes_no',
        'comment',
        'image_path'
    ];

    public function submission()
    {
        return $this->belongsTo(ChecklistSubmission::class, 'checklist_submission_id');
    }

    public function subQuestion()
    {
        return $this->belongsTo(SubQuestion::class);
    }
}

