<?php

namespace App\Models;

use App\Models\Question;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Section extends Model
{
    use HasFactory;

    protected $table = 'checklist_sections';
    protected $fillable = [
        'checklist_id',
        'title'
    ];

    public function questions()
    {
        return $this->hasMany(Question::class, 'checklist_section_id');
    }

}
