<?php

namespace App\Models;

use App\Models\Question;
use App\Models\ChecklistSubmission;
use Illuminate\Database\Eloquent\Model;

class QuestionAnswer extends Model
{
    protected $fillable = [
        'checklist_submission_id',
        'question_id',
        'room_number',
        'answer_yes_no',
        'comment',
        'image_path'
    ];

    public function submission()
    {
        return $this->belongsTo(ChecklistSubmission::class, 'checklist_submission_id');
    }

    public function question()
    {
        return $this->belongsTo(Question::class);
    }
}

