<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Jadwal extends Model
{
    use HasFactory;

    protected $table = 'schedule';

    protected $fillable = [
        'title',
        'month',
        'year',
        'events',
        'image_path',
        'is_active'
    ];

    protected $casts = [
        'events' => 'array',
        'year' => 'integer'
    ];

    /**
     * Get the full URL for the image
     */
    public function getImageUrlAttribute()
    {
        if (!$this->image_path) {
            return null;
        }
        return asset('storage/' . $this->image_path);
    }
}
