<?php
namespace App\Models;

use App\Models\Section;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Cheklist extends Model
{
    use HasFactory;

    protected $table    = 'checklists';
    protected $fillable = [
        'title',
        'hotel',
        'mod_type',
    ];

    public function sections()
    {
        return $this->hasMany(Section::class, 'checklist_id');
    }

    protected $casts = [
        'hotel' => 'string',
    ];

    public function isGeneral()
    {
        return $this->mod_type === 'general';
    }

    public function isRoomInspection()
    {
        return $this->mod_type === 'room_inspection';
    }
}
