<?php
namespace App\Models;

use App\Models\Cheklist;
use App\Models\ModSession;
use App\Models\QuestionAnswer;
use App\Models\SubQuestionAnswer;
use App\Models\User;
use Illuminate\Database\Eloquent\Model;

class ChecklistSubmission extends Model
{
    protected $fillable = [
        'checklist_id',
        'user_id',
        'mod_session_id',
        'submitted_at',
        'room_number',
        'status',
        'overall_comment',
    ];

    protected $casts = [
        'submitted_at' => 'date',
    ];

    public function checklist()
    {
        return $this->belongsTo(Cheklist::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function questionAnswers()
    {
        return $this->hasMany(QuestionAnswer::class);
    }

    public function subQuestionAnswers()
    {
        return $this->hasMany(SubQuestionAnswer::class);
    }

    public function modSession()
    {
        return $this->belongsTo(ModSession::class);
    }

    public function scopeForModType($query, string $modType)
    {
        return $query->whereHas('checklist', fn($q) => $q->where('mod_type', $modType));
    }
}
